/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <regex.h>
#include <string.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_transform.h"

/*
** This function performs transformations.
*/
int process_trnsfrm( trnsfrm_t *trnsfrm, unsigned short trnsfrm_cnt )
{
	char	*input_field_value, **output_field_value;
	size_t	input_field_len, *output_field_len;

	assert( trnsfrm != (trnsfrm_t *)0 );

	DEBUG_FUNC_START;

	for ( ; trnsfrm_cnt > (unsigned short)0; --trnsfrm_cnt, ++trnsfrm ) {
		input_field_value = *trnsfrm->input_bind->field_buffer;
		input_field_len = *trnsfrm->input_bind->field_length;

		output_field_value = trnsfrm->output_bind->field_buffer;
		output_field_len = trnsfrm->output_bind->field_length;

		switch ( trnsfrm->trnsfrm_flag ) {
		case 'R':
			/*
			** simple replace
			*/
			if ( strcmp( input_field_value, trnsfrm->search_str ) == 0 ) {
				*output_field_value = trnsfrm->replacement;
				*output_field_len = trnsfrm->replacement_len;
			}
			break;
		case 'S':
			/*
			** substitute all occurrences
			*/
			if ( input_field_len >= sizeof( trnsfrm->result ) ) {
				FPUT_SRC_CODE( stderr );
				(void) fputs( "Input field length (", stderr );
				(void) fput_uint( input_field_len, stderr );
				(void) fputs( ") is longer than maximum (", stderr );
				(void) fput_uint( sizeof( trnsfrm->result ), stderr );
				(void) fputs( ").\n", stderr );
				RETURN_INT( -1 );
			}

			(void) memcpy( (void *)trnsfrm->result, input_field_value, input_field_len + (size_t)1 );

			if ( substitute_str( trnsfrm->result, sizeof( trnsfrm->result ), trnsfrm->search_str, trnsfrm->replacement ) == -1 ) {
				RETURN_INT( -1 );
			}
			*output_field_value = trnsfrm->result;
			*output_field_len = strlen( trnsfrm->result );
			break;
		case 'B':
		case 'E':
			if ( trnsfrm_regex( output_field_value, output_field_len, input_field_value, input_field_len, trnsfrm ) == -1 ) {
				RETURN_INT( -1 );
			}
			break;
		default:
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Programming bug encountered--search flag [", stderr );
			(void) fputc( trnsfrm->trnsfrm_flag, stderr );
			(void) fputs( "].\n", stderr );
			abort();
		}
	}

	RETURN_INT( 0 );
}
