/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <assert.h>
#include <regex.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_dynamic.h"
#include "dfile_utility.h"
#include "where.h"
#include "fixed2dfile.h"


/*
** This program parses a fixed length records and stores
** values in dfile format.
*/
int main( int argc, char **argv )
{
	const char	*input_file_name, *output_dfile_name;
	const char	*filter_file_name, *control_file_name;
	char	err_msg[ 256 ];
	dfile_t	*output_dfile;
	dfile_tag_t	*dfile_tag_tbl;
	unsigned short	dfile_tag_tbl_cnt, parse_cnt;
	void	*filter;
	parse_t	*parse_tbl;
	size_t	input_record_length;

	if ( get_args( argc, argv, &input_file_name, &output_dfile_name, &dfile_tag_tbl, &dfile_tag_tbl_cnt, &filter_file_name, &control_file_name, &input_record_length ) == -1 ) {
		return 5;
	}

	DEBUG_FUNC_START;

	if ( load_control_file( &parse_tbl, &parse_cnt, control_file_name, input_record_length ) == -1 ) {
		RETURN_INT( 10 );
	}

	if ( parse_cnt == (unsigned short)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Control file contained no entries to process.\n", stderr );
		RETURN_INT( 15 );
	}

	if ( strcmp( input_file_name, "-" ) != 0 ) {
		if ( freopen( input_file_name, "rb", stdin ) == (FILE *)0 ) {
			UNIX_ERROR( "freopen() failed" );
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Failed to open data file [", stderr );
			(void) fputs( input_file_name, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( 16 );
		}
	}

	if ( open_dfile( &output_dfile, output_dfile_name, dfile_tag_tbl, dfile_tag_tbl_cnt, parse_tbl, parse_cnt ) == -1 ) {
		RETURN_INT( 25 );
	}

	if ( filter_file_name == (const char *)0 ) {
		filter = (void *)0;
	} else {
		if ( where_compile_file( &filter, err_msg, sizeof( err_msg ), filter_file_name, output_dfile ) != WHERE_NOERR ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "where_compile_file() failed [", stderr );
			(void) fputs( filter_file_name, stderr );
			(void) fputs( "]\n\t+ [", stderr );
			(void) fputs( err_msg, stderr );
			(void) fputs( "].\n", stderr );
			RETURN_INT( 26 );
		}
	}

	if ( process_file( parse_tbl, parse_cnt, output_dfile, filter, input_record_length ) == -1 ) {
		RETURN_INT( 50 );
	}

	if ( dfile_write_close( output_dfile ) == -1 ) {
		RETURN_INT( 55 );
	}

	RETURN_INT( 0 );
}
