/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <regex.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"
#include "fixed2dfile.h"


/*
** This function opens an output dfile file.
*/
int open_dfile( dfile_t **dfile, const char *dfile_name, dfile_tag_t *tag_tbl, unsigned short tag_tbl_cnt, parse_t *parse_tbl, unsigned short parse_cnt )
{
	dfile_cfg_t	cfg;
	const unsigned short	blocks_per_buffer_cnt = 4;
	const unsigned short	buffer_cnt = 1;
	dfile_bind_t	*bind_tbl, *bind;
	size_t	alloc_size;
	unsigned short	ndx;

	assert( dfile != (dfile_t **)0 );
	assert( dfile_name != (const char *)0 );
	assert( parse_tbl != (parse_t *)0 );
	assert( parse_cnt > (unsigned short)0 );

	DEBUG_FUNC_START;

	*dfile = (dfile_t *)0;

	if ( dfile_cfg( &cfg, dfile_name ) == -1 ) {
		RETURN_INT( -1 );
	}

	alloc_size = parse_cnt * sizeof( dfile_bind_t );
	bind_tbl = (dfile_bind_t *)malloc( alloc_size );
	if ( bind_tbl == (dfile_bind_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_INT( -1 );
	}

	bind = bind_tbl;

	for ( ndx = parse_cnt; ndx > (unsigned short)0; --ndx ) {
		bind->field_name = parse_tbl->field_name;
		bind->field_buffer = &parse_tbl->field_value;
		bind->field_length = &parse_tbl->field_length;
		++bind;
		++parse_tbl;
	}

	*dfile = dfile_write_open( &cfg, bind_tbl, parse_cnt, tag_tbl, tag_tbl_cnt, blocks_per_buffer_cnt, buffer_cnt, Dfile_trunc );

	if ( *dfile == (dfile_t *)0 ) {
		RETURN_INT( -1 );
	}

#if 0
	free( bind_tbl );
#endif

	RETURN_INT( 0 );
}
