/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function constructs the dfile_t structure.
*/

dfile_t *_dfile_construct( const dfile_cfg_t *cfg, const dfile_bind_t *bind, unsigned short bind_cnt, const dfile_tag_t *tag, unsigned short tag_cnt, unsigned short buffer_block_cnt, unsigned short buffer_cnt, const dfile_state_t *state_tbl )
{
	dfile_t	*dfile;
	dfile_bind_t	*new_bind, **sorted_bind;
	size_t	alloc_size;
	unsigned short	new_bind_cnt, ndx;

	DEBUG_FUNC_START;

	/*
	** Create DFile structure.
	*/
	dfile = (dfile_t *)malloc( sizeof( dfile_t ) );
	if ( dfile == (dfile_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (dfile_t *)0 );
	}

	/*
	** Populate DFile structure.
	*/
	(void) memset( (void *)dfile, 0, sizeof( dfile_t ) );

	dfile->dfile_name = cfg->dfile_name;

	dfile->rec_attribute = cfg->rec_attribute;

	dfile->file_name = _dfile_sub_tags( cfg->data_file_path, tag, tag_cnt );
	if ( dfile->file_name == (char *)0 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	new_bind_cnt = cfg->field_name_cnt;

	alloc_size = sizeof( dfile_bind_t ) * (size_t)new_bind_cnt;

	new_bind = (dfile_bind_t *)malloc( alloc_size );
	if ( new_bind == (dfile_bind_t *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (dfile_t *)0 );
	}

	if ( _dfile_alloc_bind_fields( new_bind, new_bind_cnt ) == -1 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	alloc_size = sizeof( dfile_bind_t * ) * (size_t)new_bind_cnt;
	sorted_bind = (dfile_bind_t **)malloc( alloc_size );

	if ( sorted_bind == (dfile_bind_t **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		RETURN_POINTER( (dfile_t *)0 );
	}

	dfile->bind = new_bind;
	dfile->bind_cnt = new_bind_cnt;
	dfile->sorted_bind = sorted_bind;

	for ( ndx = (unsigned short)0; ndx < new_bind_cnt; ++ndx ) {
		new_bind->field_name = cfg->field_name[ ndx ];
		sorted_bind[ ndx ] = new_bind;
		++new_bind;
	}

	if ( new_bind_cnt > (unsigned short)16 ) {
		if ( shell_sort( (void *)sorted_bind, (size_t)new_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp ) == -1 ) {
			RETURN_POINTER( (dfile_t *)0 );
		}
	} else {
		if ( insertion_sort( (void *)sorted_bind, (size_t)new_bind_cnt, sizeof( dfile_bind_t * ), dfile_bind_field_name_cmp ) == -1 ) {
			RETURN_POINTER( (dfile_t *)0 );
		}
	}

	if ( _dfile_bind( sorted_bind, new_bind_cnt, bind, bind_cnt ) == -1 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

#ifdef DFILE_THREAD
	dfile->buffer_cnt = buffer_cnt;
#endif

	dfile->buffer_base = _dfile_create_buffers( buffer_cnt, state_tbl );
	if ( dfile->buffer_base == (dfile_buffer_t *)0 ) {
		RETURN_POINTER( (dfile_t *)0 );
	}

	dfile->io_buffer = dfile->buffer_base;
	dfile->application_buffer = dfile->buffer_base;
	dfile->open_descriptor = -1;
	dfile->error = Dfile_ok;
	dfile->buffer_block_cnt = buffer_block_cnt;
	dfile->format = _dfile_identify_format( dfile->file_name );

	RETURN_POINTER( dfile );
}
