/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


static int assign_values( dfile_cfg_t *, const char ** );
static int ascii_or_decimal( char *, const char * );
#if 0
static int set_fields( const char ***, dfile_bind_t *, unsigned short );
#endif
static void print_dfile_cfg( dfile_cfg_t * );

#define	CFG_FIELD_CNT	6

/*
** This function is called by user program to get configuration information
** about a file. Configuration information includes data file path(s) and field
** definitions for record layout.
*/

int dfile_cfg( dfile_cfg_t *cfg, const char *file_reference )
{
	readstat_t	readstat;
	const char	*cfg_field[CFG_FIELD_CNT];
	const unsigned short	cfg_field_cnt = CFG_FIELD_CNT;

	assert( cfg != (dfile_cfg_t *)0 );
	assert( file_reference != (const char *)0 );

	DEBUG_FUNC_START;

	readstat = cfg_lookup( cfg_field, cfg_field_cnt, ':', "dfile.cfg", CFG_ENV_PATH, file_reference );

	if ( readstat != Read_ok ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Failed to get information related to DFile [", stderr );
		(void) fputs( file_reference, stderr );
		(void) fputs( "].\n", stderr );

		RETURN_INT( -1 );
	}

	if ( assign_values( cfg, cfg_field ) == -1 ) {
		RETURN_INT( -1 );
	}

	if ( Debug ) {
		print_dfile_cfg( cfg );
	}
	RETURN_INT( 0 );
}

static int assign_values( dfile_cfg_t *cfg, const char **cfg_field )
{
	dfile_rec_t	*rec_attribute;
	FILE	*fptr;
	char	*env_str;

	cfg->dfile_name = strdup( cfg_field[ 0 ] );
	if ( cfg->dfile_name == (char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		return -1;
	}

	rec_attribute = &cfg->rec_attribute;

	if ( ascii_or_decimal( &rec_attribute->field_separator, cfg_field[ 1 ] ) == -1 ) {
		return -1;
	}

	if ( ascii_or_decimal( &rec_attribute->record_separator, cfg_field[ 2 ] ) == -1 ) {
		return -1;
	}

	if ( ascii_or_decimal( &rec_attribute->separator_escape, cfg_field[ 3 ] ) == -1 ) {
		return -1;
	}

	env_str = strenv( cfg_field[ 4 ] );
	if ( env_str == (char *)0 ) {
		return -1;
	}

	cfg->record_layout_path = strdup( env_str );
	if ( cfg->record_layout_path == (char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		return -1;
	}

	fptr = cfg_open( cfg->record_layout_path, CFG_ENV_PATH );
	if ( fptr == (FILE *)0 ) {
		return -1;
	}

	if ( _dfile_read_registry_field_file( &cfg->field_name, &cfg->field_name_cnt, fptr ) == -1 ) {
		return -1;
	}

	if ( fclose( fptr ) == EOF ) {
		UNIX_ERROR( "fclose() failed" );
	}

#if 0
	if ( set_fields( &cfg->field, cfg->bind, cfg->bind_cnt ) == -1 ) {
		return -1;
	}
#endif

	env_str = strenv( cfg_field[ 5 ] );
	if ( env_str == (char *)0 ) {
		return -1;
	}

	cfg->data_file_path = strdup( env_str );
	if ( cfg->data_file_path == (char *)0 ) {
		UNIX_ERROR( "strdup() failed" );
		return -1;
	}

	return 0;
}

static int ascii_or_decimal( char *result, const char *value )
{
	char	*ptr;
	long	int_value;
	size_t	len;

	if ( *value == (char)0 ) {
		/*
		** Null value.
		*/
		*result = (char)0;
		return 0;
	}

	len = strlen( value );

	if ( isdigit( value[ 0 ] ) ) {
		/*
		** Decimal value instead of ASCII.
		*/
		int_value = strtol( value, &ptr, 10 );

		if ( value >= ptr || (size_t)( ptr - value ) != len ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "failed to convert [", stderr );
			(void) fputs( value, stderr );
			(void) fputs( "] to an integer.\n", stderr );
			return -1;
		}

		if ( int_value < 1L || int_value > 127L ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "decimal value [", stderr );
			(void) fputs( value, stderr );
			(void) fputs( "] is not in range 1 to 127.\n", stderr );
			return -1;
		}

		*result = (char)int_value;
		return 0;
	}

	if ( len != (size_t)1 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "ASCII character or decimal value expected, found [", stderr );
		(void) fputs( value, stderr );
		(void) fputs( "].\n", stderr );

		return -1;
	}

	*result = *value;

	return 0;
}

#if 0

static int set_fields( const char ***field, dfile_bind_t *bind, unsigned short field_cnt )
{
	size_t	alloc_size;
	unsigned short	ndx;

	alloc_size = sizeof( char * ) * (size_t)field_cnt;

	*field = (const char **)malloc( alloc_size );

	if ( *field == (const char **)0 ) {
		UNIX_ERROR( "malloc() failed" );
		return -1;
	}

	for ( ndx = (unsigned short)0; ndx < field_cnt; ++ndx ) {
		( *field )[ ndx ] = bind[ ndx ].field_name;
	}

	return 0;
}
#endif

static void print_dfile_cfg( dfile_cfg_t *cfg )
{
	unsigned short	ndx;

	(void) fprintf( stderr, "dfile name [%s]\n", cfg->dfile_name );
	(void) fprintf( stderr, "field_separator %d, record_separator %d, separator_escape %d\n", cfg->rec_attribute.field_separator, cfg->rec_attribute.record_separator, cfg->rec_attribute.separator_escape );
	(void) fprintf( stderr, "record_layout_path [%s]\n", cfg->record_layout_path );
	(void) fprintf( stderr, "data_file_path [%s]\n", cfg->data_file_path );

	(void) fputs( "Fields:\n", stderr );
	for ( ndx = (unsigned short)0; ndx < cfg->field_name_cnt; ++ndx ) {
		(void) fprintf( stderr, "%8hu. [%s]\n", ndx + 1, cfg->field_name[ ndx ] );
	}
}
