/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <zlib.h>
#include "tbox.h"
#include "dfile.h"
#include "_dfile.h"


/*
** This function is used by user application to cleanup after calling
** dfile_write_open() and dfile_write(). This includes flushing remaining
** buffers and freeing memory.
*/

int dfile_write_close( dfile_t *dfile )
{
	int	ret;
	dfile_buffer_t	*buffer;
#ifdef DFILE_THREAD
	void	*thread_return;
#endif

	DEBUG_FUNC_START;

	if ( dfile == (dfile_t *)0 ) {
		FPUT_SRC_CODE( stderr );
		(void) fputs( "Function argument to dfile_write_close() cannot be null.\n", stderr );
		abort();
	}

	buffer = dfile->application_buffer;
	assert( buffer != (dfile_buffer_t *)0 );

#ifdef DFILE_THREAD
	if ( dfile->buffer_cnt == (unsigned short)1 ) {
#endif
		buffer->processing_complete_flag = 'Y';
		ret = ( *dfile->io_buffer_func)( dfile );
#ifdef DFILE_THREAD
	} else {
		if ( _dfile_buffer_wait( buffer, Dfile_format_state, dfile->buffer_cnt ) == -1 ) {
			RETURN_INT( -1 );
		}

		buffer->processing_complete_flag = 'Y';
		if ( _dfile_release_buffer( buffer ) == -1 ) {
			RETURN_INT( -1 );
		}

		if ( dfile->buffer_cnt > (unsigned short)1 ) {
			ret = pthread_join( dfile->thread, &thread_return );
			if ( ret != 0 ) {
				thread_error( "pthread_join() failed", __FILE__, __LINE__, ret );
				RETURN_INT( -1 );
			}
		}

		ret = ( dfile->error == Dfile_ok ) ? 0 : -1;
	}
#endif

	if ( close( dfile->open_descriptor ) < 0 ) {
		UNIX_ERROR( "close() failed" );
		ret = -1;
	}

	if ( dfile->zstream != (void *)0 ) {
		if ( deflateEnd( (z_stream *)dfile->zstream ) != Z_OK ) {
			FPUT_SRC_CODE( stderr );
			(void) fputs( "Failed to free GZIP stream.\n", stderr );
		}
	}

	_dfile_free( dfile );

	RETURN_INT( ret );
}
