/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "dfile.h"
#include "dfile_utility.h"


/*
** This function frees memory containing temporary field values.
*/
void free_record( field_t **rec, unsigned long rec_cnt )
{
	field_t	**ptr, *field;

	assert( rec != (field_t **)0 );

	DEBUG_FUNC_START;

	for ( ptr = rec; rec_cnt > 0UL; --rec_cnt, ++ptr ) {
		field = *ptr;
		free( (void *)field->value );
		free( (void *)field );
	}

	free( (void *)rec );

	RETURN_VOID;
}
