/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include "tbox.h"
#include "sexpr.h"


/*
** This function allows external library access to read and parse a file that
** contains an s-expression.
** Return value is zero for okay, -1 for UNIX error and positive value
** to represent particular s-expression failure.
*/

int sexpr_load( sexpr_t **sexpr, const char *file_name )
{
	int	ret;
	size_t	str_len;
	char	*str;

	assert( sexpr != (sexpr_t **)0 );
	assert( file_name != (const char *)0 );

	DEBUG_FUNC_START;

	if ( Debug ) {
		(void) fputs( "loading file [", stderr );
		(void) fputs( file_name, stderr );
		(void) fputs( "]\n", stderr );
	}

	if ( load_script_file( &str, &str_len, file_name, '#' ) == -1 ) {
		RETURN_INT( -1 );
	}

	ret = sexpr_parse( sexpr, str );
	if ( ret != 0 ) {
		RETURN_INT( ret );
	}

	free( (void *)str );

	RETURN_INT( ret );
}
