/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "tbox.h"


/*
** This file contains wrapper functions for converting simple
** data types to ASCII strings.
*/

/*
** This function does a double to ASCII conversion.
*/
const char *xdtoa( double x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%g", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from double to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does a short to ASCII conversion.
*/
const char *stoa( short x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%hd", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from short to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does an unsigned short to ASCII conversion.
*/
const char *ustoa( unsigned short x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%hu", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from unsigned short to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does a long to ASCII conversion.
*/
const char *ltoa( long x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%ld", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from long to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does an unsigned long to ASCII conversion.
*/
const char *ultoa( unsigned long x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%lu", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from unsigned long to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does an int to ASCII conversion.
*/
const char *itoa( int x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%d", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from int to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

/*
** This function does an unsigned int to ASCII conversion.
*/
const char *utoa( unsigned int x )
{
	static char	result[40];

	DEBUG_FUNC_START;

	if ( snprintf( result, sizeof( result ), "%u", x ) <= 0 ) {
		UNIX_ERROR( "snprintf() failed to convert from unsigned int to ASCII" );

		RETURN_POINTER( (const char *)0 );
	}

	if ( Debug ) {
		(void) fprintf( stderr, "result = [%s]\n", result );
	}

	RETURN_POINTER( result );
}

#ifdef MT_toa_wrappers
/*
** This function is used to regression test toa wrappers.
** The following command is used to compile:
** x=toa_wrappers; make "MT_CC=-DMT_$x" "MT_PRE=DEFINE=MT_$x" $x
*/
int main( void )

{
	const char	*ptr;

	Debug = 1;

	ptr = dtoa( 5.0 );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "dtoa( 5.0 ) returned [%s].\n\n", ptr );

	ptr = stoa( (short)5 );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "stoa( 5 ) returned [%s].\n\n", ptr );

	ptr = ustoa( (unsigned short)5 );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "ustoa( 5 ) returned [%s].\n\n", ptr );

	ptr = ltoa( 5L );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "ltoa( 5 ) returned [%s].\n\n", ptr );

	ptr = ultoa( 5UL );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "ultoa( 5 ) returned [%s].\n\n", ptr );

	ptr = itoa( 5 );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "itoa( 5 ) returned [%s].\n\n", ptr );

	ptr = utoa( 5U );
	if ( ptr == (const char *)0 ) {
		fputs( "FAILURE\n", stderr );
		return 1;
	}
	(void) fprintf( stderr, "utoa( 5 ) returned [%s].\n", ptr );

	exit( 0 );
}
#endif
