/* Copyright (C) 2009, 2010, 2011, 2012 Keith Crane

This file is part DFILE Tools.

DFILE Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or (at
your option) any later version.

DFILE Tools is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with DFILE Tools; see the file COPYING.  If not, see
<http://www.gnu.org/licenses/>. */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tbox.h"
#include "nsplit.h"

/*
** This program splits large ASCII data files into a number of smaller files
** that are roughly the same size.
*/
int main( int argc, char **argv )
{
	const char	*input_filename, *output_filename;
	char	*buffer, *remaining;
	unsigned short	split_cnt, file_ndx;
	off_t	input_filesize, output_filesize;
	size_t	io_blksize, buffer_length;
	int	input_fd, output_fd;

	if ( get_args( argc, argv, &input_filename, &output_filename, &split_cnt ) == -1 ) {
		return 10;
	}

	if ( open_input_file( &input_fd, &input_filesize, &io_blksize, input_filename ) == -1 ) {
		return 20;
	}

	buffer = (char *)malloc( io_blksize );
	if ( buffer == (char *)0 ) {
		UNIX_ERROR( "malloc() failed" );
		return 30;
	}

	output_filesize = ( input_filesize / split_cnt ) + 1;

	if ( Debug ) {
		(void) fprintf( stderr, "Output file size is %llu.\n", output_filesize );
	}

	remaining = (char *)0;
	buffer_length = (size_t)0;

	for ( file_ndx = (unsigned short)0; file_ndx < split_cnt; ++file_ndx ) {
		if ( open_output_file( &output_fd, output_filename, file_ndx ) == -1 ) {
			return 40;
		}

		if ( copy_data( &remaining, &buffer_length, output_fd, input_fd, buffer, io_blksize, output_filesize ) == -1 ) {
			return 50;
		}

		if ( close( output_fd ) < 0 ) {
			UNIX_ERROR( "close() failed" );
			return 60;
		}
	}

	return 0;
}
