## $Id: dhcp-forwarder.spec.in,v 1.5 2002/06/14 17:36:50 ensc Exp $		--*- rpm-spec -*--

%define		homedir		%{_var}/lib/dhcpfwd

Summary:	An DHCP relay agent
Name:		dhcp-forwarder
Version:	0.2
Release:	1
License:	GPL
Group:		System Environment/Daemons
Packager:	Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
URL:		http://www.tu-chemnitz.de/~ensc/dhcpfwd
Source0:	%{name}-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot

%if %{?_without_dietlibc:0}%{!?_without_dietlibc:1}
BuildRequires:	dietlibc
%endif


%description
dhcp-fwd forwards DHCP messages between subnets with different sublayer
broadcast domains. It is similar to the DHCP relay agent dhcrelay of
ISC's DHCP, but has the following features which are important for me:

* Runs as non-root in a chroot-jail
* Uses "normal" AF_INET sockets which allows to uses packagefilters to
  filter incoming messages.
* The DHCP agent IDs can be defined freely
* Has a small memory footprint when using dietlibc


%prep
%setup -q

%build
%configure --enable-release %{?_without_dietlibc:--disable-dietlibc}
make

%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=${RPM_BUILD_ROOT} install-strip install-contrib

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}
install -m 644 contrib/dhcp-fwd.conf ${RPM_BUILD_ROOT}%{_sysconfdir}/
install -m700 -d ${RPM_BUILD_ROOT}%{homedir}


%clean
rm -rf $RPM_BUILD_ROOT


%pre
/usr/sbin/adduser -r -s /sbin/nologin -d %{homedir} -M		\
	 	  -c 'DHCP Forwarder user' dhcpfwd &>/dev/null || true

%post
/sbin/chkconfig --add dhcp-fwd

%preun
if test "$1" = "0"; then
	/sbin/chkconfig --del dhcp-fwd
fi

%postun
if test "$1" = "0"; then
	/usr/sbin/userdel dhcpfwd &>/dev/null || true
fi


%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README THANKS
%doc %{_mandir}/*/*
%config /etc/init.d/*
%config(noreplace) %{_sysconfdir}/dhcp-fwd.conf
%{_sbindir}/*
%{homedir}


%changelog
* Fri Jun 14 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0.2-1
- Added manpage

* Thu Jun 13 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0.1-0.3
- Added --without dietlibc option

* Sat Jun  1 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 
- Initial build.
