/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef ACTIVITYMODULE_H
#define ACTIVITYMODULE_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QFormLayout>
#include <QScrollArea>
#include <QListWidget>
#include <QLineEdit>
#include <QComboBox>
#include <QSpinBox>
#include <QTimeEdit>
#include <QDateEdit>
#include <QCalendarWidget>
#include <QCheckBox>
#include <QPushButton>
#include <QMessageBox>

#include <QDebug>

#include "globalobject.h"
#include "activityhandler.h"
#include "stringlistwidget.h"
#include "datafile.h"


class ActivityModule : public QWidget
{
    Q_OBJECT

public:
    explicit ActivityModule(ActivityHandler *handler,
                            GlobalObject *globalObject,
                            QWidget *parent = 0);
    ~ActivityModule();

    void loadActivities();

    bool validateActivity();


signals:


public slots:
    void onNameChanged(QString newName);

    void onRecipientsTypeChanged(int option);

    void addActivity();
    void removeActivity();

    void onActivitySelected(int row);

    void saveActivity();

    void syncActivities();


private:
    QHBoxLayout *mainLayout;

    QVBoxLayout *leftLayout;
    QPushButton *syncActivitiesButton;
    QListWidget *activityListWidget;
    QPushButton *addActivityButton;
    QPushButton *removeActivityButton;


    QScrollArea *rightScrollArea;
    QWidget *rightWidget;
    QVBoxLayout *rightLayout;
    QFormLayout *formLayout;    

    QLineEdit *nameLineEdit;

    QSpinBox *timesPerDaySpinbox;
    QSpinBox *probabilitySpinbox;

    QHBoxLayout *timeLayout;
    QTimeEdit *minTimeEdit;
    QTimeEdit *maxTimeEdit;

    QHBoxLayout *dateLayout;
    QDateEdit *minDateEdit;
    QDateEdit *maxDateEdit;

    QHBoxLayout *durationLayout;
    QSpinBox *minDurationSpinbox;
    QSpinBox *maxDurationSpinbox;

    QComboBox *statusTypeCombobox;
    StringListWidget *statusMessagesListWidget;

    QSpinBox *availabilitySpinbox;

    QHBoxLayout *reactionLayout;
    QSpinBox *minReactionSpinbox;
    QSpinBox *maxReactionSpinbox;

    StringListWidget *descriptionListWidget;

    StringListWidget *msgBeforeListWidget;
    StringListWidget *msgAfterListWidget;

    QHBoxLayout *msgRecipientsLayout;
    QComboBox *msgToRoomsCombobox;
    QLineEdit *specificJidsLineEdit;
    QCheckBox *msgToChatsCheckbox;

    QPushButton *saveActivityButton;


    DataFile *dataFile;
    ActivityHandler *activityHandler;
    GlobalObject *globalObj;
};

#endif // ACTIVITYMODULE_H
