/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CHATMODULE_H
#define CHATMODULE_H

#include <QWidget>
#include <QVBoxLayout>
#include <QLabel>
#include <QTabWidget>
#include <QTabBar>

#include <QDebug>

#include <QXmppClient.h>

#include "globalobject.h"
#include "chatwidget.h"


class ChatModule : public QWidget
{
    Q_OBJECT

public:
    explicit ChatModule(GlobalObject *globalObject, QWidget *parent = 0);
    ~ChatModule();

    void setTabTitle(int tabNumber, QString name, int unread);


signals:
    void unreadCountChanged(int count);


public slots:
    void addChatTab(QXmppMessage message);
    void updateTabTitle(int count);
    void closeTab(int tabIndex);


private:
    QVBoxLayout *mainLayout;
    QTabWidget *tabWidget;

    QList<ChatWidget *> openedChats;

    int unreadCount;

    QXmppClient *xmppClient;
    GlobalObject *globalObj;
};

#endif // CHATMODULE_H
