/*
 *   This file is part of AkariXB
 *   Copyright 2015-2016  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "conversationmodule.h"


ConversationModule::ConversationModule(QWidget *parent) : QWidget(parent)
{
    // tests / placeholders
    QTreeWidgetItem *category1_1 = new QTreeWidgetItem();
    category1_1->setText(0, "So+me (nice.*) regexp to expect");
    category1_1->setText(1, "ActionValues");

    QTreeWidgetItem *category1 = new QTreeWidgetItem();
    category1->setText(0, "General");
    category1->addChild(category1_1);
    QTreeWidgetItem *category2 = new QTreeWidgetItem();
    category2->setText(0, "Personal");
    QTreeWidgetItem *category3 = new QTreeWidgetItem();
    category3->setText(0, "Greetings");
    QTreeWidgetItem *category4 = new QTreeWidgetItem();
    category4->setText(0, "People");
    QTreeWidgetItem *category5 = new QTreeWidgetItem();
    category5->setText(0, "Places");


    this->conversationTreeWidget = new QTreeWidget(this);
    conversationTreeWidget->setColumnCount(2);
    conversationTreeWidget->addTopLevelItem(category1);
    conversationTreeWidget->addTopLevelItem(category2);
    conversationTreeWidget->addTopLevelItem(category3);
    conversationTreeWidget->addTopLevelItem(category4);
    conversationTreeWidget->addTopLevelItem(category5);

    this->mainLayout = new QVBoxLayout();
    this->mainLayout->addWidget(conversationTreeWidget);
    this->setLayout(mainLayout);

    qDebug() << "ConversationModule created";
}


ConversationModule::~ConversationModule()
{
    qDebug() << "ConversationModule destroyed";
}


//////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// SLOTS //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


