/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef DIASPORACONTROLLER_H
#define DIASPORACONTROLLER_H

#include <QObject>
#include <QStringList>
#include <QByteArray>
#include <QUrl>
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
#include <QUrlQuery>
#endif
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QSslError> // TMP
#include <QTimer>

#include <QDebug>

/// For JSON parsing
#include <QVariant>
#include <QVariantMap>
#include <qjson/parser.h>



class DiasporaController : public QObject
{
    Q_OBJECT

public:
    DiasporaController(QObject *parent = 0);
    ~DiasporaController();

    void setUserCredentials(QString userID, QString userAuth);

    void getUserProfile(QString userID);
    void getAvatar(QString avatarURL);
    void getImage(QString imageURL);
    void getAspectList();
    void getContactList();
    void getTimeline();
    void getPost(int id);

    enum requestTypes
    {
        NoRequest,
        AspectListRequest,
        ContactListRequest,
        TimelineRequest,
        PostRequest,
        AvatarRequest,
        ImageRequest,

        PublishPostRequest
    };


signals:
    void profileReceived(QString fullName);
    void aspectListReceived(QVariantList aspectList);
    void contactListReceived(QVariantList contactList);
    void timeLineReceived(QVariantList postList);
    void postReceived(QVariantMap post);
    void avatarPictureReceived(QByteArray pictureData, QUrl pictureURL);
    void imageReceived(QByteArray pictureData, QUrl pictureURL);

    void showNotification(QString message);
    void currentJobChanged(QString message);

public slots:
    void requestFinished(QNetworkReply *reply);
    void sslErrorsHandler(QNetworkReply *reply, QList<QSslError> errorList); // Tests

    void getInitialData();

    void post(QString postText); // FIXME: more params

    void setCurrentTimeline(QString link);

private:
    QNetworkAccessManager nam;
    QByteArray userAgentString;

    QString userID;
    QString userAuth;

    QString userName;
    QString serverURL;


    QTimer *initialDataTimer;
    int initialDataStep;

};

#endif // DIASPORACONTROLLER_H
