/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QApplication>
#include <QTranslator>
#include <iostream>

#include "mainwindow.h"


int main(int argc, char *argv[])
{
    QApplication dianaraApp(argc, argv);
    dianaraApp.setApplicationName("Dianara");
    dianaraApp.setApplicationVersion("0.4");
    dianaraApp.setOrganizationName("JanCoding");
    dianaraApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("%1 v%2 - JanKusanagi 2012\n")
                     .arg(dianaraApp.applicationName())
                     .arg(dianaraApp.applicationVersion()).toStdString();
    std::cout.flush();

    // Load translation files
    QTranslator translator;
    QString languageFile;
    // Generate resource name from LANG variable
    languageFile = QString(":/translations/dianara_%1")
                   .arg(qgetenv("LANG").constData());
    qDebug() << "Trying to load translation file:" << languageFile;

    translator.load(languageFile);
    dianaraApp.installTranslator(&translator);


    MainWindow dianaraWindow;
    dianaraWindow.show();


    return dianaraApp.exec();
}
