/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef PUMPCONTROLLER_H
#define PUMPCONTROLLER_H

#include <QObject>
#include <QStringList>
#include <QByteArray>
#include <QUrl>
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
#include <QUrlQuery>
#endif
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QNetworkAccessManager>
#include <QSslError> // TMP
#include <QTimer>

#include <QSettings>
#include <QDesktopServices>

#include <QDebug>


/// For JSON parsing
#include <QVariant>
#include <QVariantMap>
#include <qjson/parser.h>

// For OAuth authentication
#include <QtOAuth>


class PumpController : public QObject
{
    Q_OBJECT

public:
    explicit PumpController(QObject *parent = 0);
    ~PumpController();

    void setNewUserID(QString userID);
    void setUserCredentials(QString userID);

    void getUserProfile(QString userID);
    void getAvatar(QString avatarURL);
    void getImage(QString imageURL);
    void getContactList();
    void getTimeline();
    void getPost(int id);

    enum requestTypes
    {
        NoRequest,

        ClientRegistrationRequest,
        TokenRequest,

        UserProfileRequest,
        ContactListRequest,
        TimelineRequest,
        PostRequest,
        AvatarRequest,
        ImageRequest,

        PublishPostRequest
    };



signals:
    void authorizationStatusChanged(bool authorized);

    void profileReceived(QString fullName, QString avatarURL);
    void contactListReceived(QVariantList contactList);
    void timeLineReceived(QVariantList postList);
    void postReceived(QVariantMap post);
    void avatarPictureReceived(QByteArray pictureData, QUrl pictureURL);
    void imageReceived(QByteArray pictureData, QUrl pictureURL);

    void showNotification(QString message);
    void currentJobChanged(QString message);


public slots:
    void requestFinished(QNetworkReply *reply);
    void sslErrorsHandler(QNetworkReply *reply, QList<QSslError> errorList); // Tests

    void getToken();
    void authorizeApplication(QString verifierCode);

    void getInitialData();

    void post(QString postText); // FIXME: more params
    void likePost(QString postID);

    void setCurrentTimeline(QString link);



private:
    QNetworkAccessManager nam;
    QByteArray userAgentString;

    QString userID;  // Full webfinger address, user@host.tld
    QString userName;
    QString serverURL;

    // QOAuth-related
    QOAuth::Interface *qoauth;

    bool isApplicationAuthorized;

    QString clientID;
    QString clientSecret;

    QByteArray token;
    QByteArray tokenSecret;



    QTimer *initialDataTimer;
    int initialDataStep;

};

#endif // PUMPCONTROLLER_H
