/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef TIMELINE_H
#define TIMELINE_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QVariantList>
#include <QMap>
#include <QSplitter>
#include <QPushButton>

#include <QDebug>

#include "pumpcontroller.h"
#include "post.h"


class TimeLine : public QWidget
{
    Q_OBJECT

public:
    TimeLine(PumpController *pumpController,
             QWidget *parent = 0);
    ~TimeLine();

    void clearTimeLineContents();

signals:
    void getPreviousPage();
    void getNextPage();

public slots:
    void setTimeLineContents(QVariantList postList);

private:
    QVBoxLayout *mainLayout;
    QSplitter *splitter;
    QHBoxLayout *bottomLayout;

    PumpController *pController;

    QPushButton *previousButton;
    QPushButton *nextButton;
};

#endif // TIMELINE_H
