/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "commenter.h"

Commenter::Commenter(QWidget *parent) : QWidget(parent)
{    
    this->commentsLabel = new QLabel();
    commentsLabel->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    commentsLabel->setWordWrap(true);
    QFont commentsFont;
    commentsFont.setPointSize(9);
    commentsLabel->setFont(commentsFont);
    commentsLabel->hide(); // hide until setComments() is called, if there are any

    this->commentComposer = new Composer();
    this->commentComposer->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    this->commentComposer->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    connect(commentComposer, SIGNAL(editingFinished()),  this, SLOT(sendComment()));
    connect(commentComposer, SIGNAL(editingCancelled()), this, SLOT(setMinimumMode()));

    this->commentButton = new QPushButton(tr("&Comment"));
    connect(commentButton, SIGNAL(clicked()), this, SLOT(sendComment()));


    mainLayout = new QGridLayout();
    mainLayout->addWidget(commentsLabel,   0, 0, 1, 2);
    mainLayout->addWidget(commentComposer, 1, 0, 1, 1);
    mainLayout->addWidget(commentButton,   1, 1, 1, 1);
    this->setLayout(mainLayout);


    this->setMinimumMode();

    qDebug() << "Commenter created";
}


Commenter::~Commenter()
{
    qDebug() << "Commenter destroyed";
}



void Commenter::setCommments(QString comments)
{
    if (!comments.isEmpty())
    {
        this->commentsLabel->setText(comments);

        this->commentsLabel->show();
    }
}



/*******************************************************************/
/****************************** SLOTS ******************************/
/*******************************************************************/


void Commenter::setMinimumMode()
{
    this->commentComposer->hide();
    this->commentButton->hide();

    // Clear formatting options like bold or italic
    this->commentComposer->setCurrentCharFormat(QTextCharFormat());
}



void Commenter::setFullMode()
{
    this->commentComposer->show();
    this->commentButton->show();

    this->commentComposer->setFocus();
}




void Commenter::sendComment()
{
    qDebug() << "Commenter character count:" << commentComposer->toPlainText().length();

    // If there's some text in the comment, send it
    if (!commentComposer->toPlainText().isEmpty())
    {
        emit commentSent(commentComposer->toPlainText());

        this->commentComposer->erase();

        // Done posting the comment, hide
        setMinimumMode();
    }
    else
    {
        qDebug() << "Can't post, comment is empty";
    }
}
