/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "contactlist.h"

ContactList::ContactList(PumpController *pumpController,
                         QWidget *parent) : QWidget(parent)
{
    this->pController = pumpController;

    mainLayout = new QVBoxLayout();
    mainLayout->setAlignment(Qt::AlignTop);


    topLayout = new QHBoxLayout();
    addressLineEdit = new QLineEdit();
    addressLineEdit->setPlaceholderText(tr("Enter a Webfinger address, like username@pumpserver.org"));

    followButton = new QPushButton(QIcon::fromTheme("list-add"), tr("&Follow"));
    connect(followButton, SIGNAL(clicked()),
            this, SLOT(followContact()));
    topLayout->addWidget(addressLineEdit);
    topLayout->addWidget(followButton);

    mainLayout->addLayout(topLayout);

    contactsLayout = new QVBoxLayout();

    QMap<QString,QString> demoContactData;
    demoContactData.insert("name", "Demo Contact");
    demoContactData.insert("id",   "democontact@somepumpserver.org");
    demoContactData.insert("avatar", "");
    demoContactData.insert("follower", "true");
    demoContactData.insert("following", "true");
    contactsLayout->addWidget(new ContactCard(this->pController, demoContactData, this));

    mainLayout->addLayout(contactsLayout);
    this->setLayout(mainLayout);

    qDebug() << "Contact list created";
}


ContactList::~ContactList()
{
    qDebug() << "Contact list destroyed";
}



void ContactList::clearContactListContents()
{
    QLayoutItem *child;

    while ((child = contactsLayout->takeAt(0)) != 0)
    {
        child->widget()->deleteLater(); // Delete the widget (contactCard) itself
        delete child;
    }
}





/*****************************************************************************/
/*********************************** SLOTS ***********************************/
/*****************************************************************************/




void ContactList::setContactListContents(QVariantList contactList)
{
    qDebug() << "Setting contact list contents";
    this->clearContactListContents();


    QMap<QString,QString> contactData;

    foreach (QVariant contact, contactList)
    {
        contactData.insert("name", contact.toMap().value("displayName").toString());
        contactData.insert("id", contact.toMap().value("id").toString().remove(0,5)); // remove "acct:"
        contactData.insert("avatar", contact.toMap().value("image").toMap().value("url").toString());
        contactData.insert("follower", "false"); // tmp, until we have followers/following separation
        contactData.insert("following", "true");

        this->contactsLayout->addWidget(new ContactCard(this->pController,
                                                        contactData,
                                                        this));
    }
}




/*
 * Add the address entered by the user to the /following list.
 *
 * This should probably support adding webfinger addresses
 * in the form https://host/username too.
 *
 */
void ContactList::followContact()
{
    QString address = this->addressLineEdit->text();

    qDebug() << "ContactList::followContact()" << address;

    if (address.contains("@")) // FIXME, check correctly
    {
        this->pController->followContact(address); // this will trigger a reload of the contact list

        this->addressLineEdit->clear();
    }
    else
    {
        qDebug() << "Invalid webfinger address!";
    }

}
