/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CONTACTLIST_H
#define CONTACTLIST_H

#include <QWidget>
#include <QLabel>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QVariantList>
#include <QMap>
#include <QString>
#include <QPushButton>
#include <QLineEdit>

#include <QDebug>

#include "pumpcontroller.h"
#include "contactcard.h"


class ContactList : public QWidget
{
    Q_OBJECT

public:
    ContactList(PumpController *pumpController, QWidget *parent = 0);
    ~ContactList();

    void clearContactListContents();

signals:

public slots:
    void setContactListContents(QVariantList contactList);

    void followContact();

private:
    QVBoxLayout *mainLayout;

    QHBoxLayout *topLayout;
    QLineEdit *addressLineEdit;

    QVBoxLayout *contactsLayout;
    QPushButton *followButton;

    PumpController *pController;
};

#endif // CONTACTLIST_H
