/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QApplication>
#include <QTranslator>
#include <iostream>

#include "mainwindow.h"





#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
void customMessageHandlerQt4(QtMsgType type, const char *msg)
{
    // do nothing
    Q_UNUSED(type)
    Q_UNUSED(msg)

    return;
}
#else
void customMessageHandlerQt5(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
    Q_UNUSED(type)
    Q_UNUSED(context)
    Q_UNUSED(msg)

    // Do nothing

    return;
}
#endif



int main(int argc, char *argv[])
{
    QApplication dianaraApp(argc, argv);
    dianaraApp.setApplicationName("Dianara");
    dianaraApp.setApplicationVersion("0.5");
    dianaraApp.setOrganizationName("JanCoding");
    dianaraApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("%1 v%2 - JanKusanagi 2012-2013\n")
                     .arg(dianaraApp.applicationName())
                     .arg(dianaraApp.applicationVersion()).toStdString();
    std::cout.flush();


    // Register custom message handler, to hide debug messages unless specified
    if (qApp->arguments().contains("--debug", Qt::CaseInsensitive))
    {
        qDebug() << "Debug messages enabled";
    }
    else
    {
        qDebug() << "To see debug messages while running, use --debug";
   #if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
        qInstallMsgHandler(customMessageHandlerQt4);
   #else
        qInstallMessageHandler(customMessageHandlerQt5);
   #endif
    }


    // Load translation files
    QTranslator translator;
    QString languageFile;
    // Generate resource name from LANG variable
    languageFile = QString(":/translations/dianara_%1")
                   .arg(qgetenv("LANG").constData());
    qDebug() << "Trying to load translation file:" << languageFile;

    translator.load(languageFile);
    dianaraApp.installTranslator(&translator);


    MainWindow dianaraWindow;
    dianaraWindow.show();


    return dianaraApp.exec();
}
