/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <QMainWindow>
#include <QApplication>
#include <QSettings>
#include <QMenuBar>
#include <QStatusBar>
#include <QSystemTrayIcon>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QToolBox>
#include <QTabWidget>
#include <QLabel>
#include <QCloseEvent>
#include <QByteArray>
#include <QPixmap>
#include <QMessageBox>
#include <QDir>
#include <QTimer>
#include <QScrollArea>
#include <QScrollBar>
#include <QVariantList>
#include <QDesktopServices>
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
#include <QStandardPaths>
#endif
#include <QTime>
#include <QSplitter>

#include <QDebug>

#include "account.h"
#include "configdialog.h"
#include "pumpcontroller.h"
#include "notifications.h"
#include "publisher.h"
#include "timeline.h"
#include "post.h"
#include "messagelist.h"
#include "contactlist.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT


public:    
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void prepareDataDirectory();
    void createMenus();
    void createTrayIcon();
    void loadSettings();
    void saveSettings();


public slots:
    void updateUserID(QString newUserID);
    void updateSettings(int newUpdateInterval,
                        int newPostsPerPage,
                        int newTabsPosition,
                        bool newTabsMovable,
                        int newPublisherType,
                        int newShowNotifications);

    void trayControl(QSystemTrayIcon::ActivationReason reason);
    void showTrayFallbackMessage(QString message);

    void updateProfileData(QString fullName, QString avatarURL);
    void updateAspectList(QVariantList aspectList);

    void updateTimelines();
    void scrollTimelineToTop();
    void notifyTimelineUpdate(int newPostCount);

    void storeAvatar(QByteArray avatarData, QUrl avatarURL);
    void storeImage(QByteArray imageData, QUrl imageURL);

    void setStatusBarMessage(QString message);


    void toggleSidePanel(bool shown);

    void visitWebSite();
    void aboutDianara();
    void quitProgram();


protected:
    virtual void closeEvent(QCloseEvent *event);


private:
    QMenu *sessionMenu;
    QMenu *viewMenu;
    QMenu *settingsMenu;
    QMenu *helpMenu;

    QMenu *trayContextMenu;

    QAction *sessionUpdateTimelines;
    QAction *sessionStartConversation;
    QAction *sessionQuit;
    QAction *viewSidePanel;
    QAction *settingsAccount;
    QAction *settingsConfigure;
    QAction *helpVisitWebsite;
    QAction *helpAbout;


    QSplitter *mainSplitter;

    QWidget *leftSideWidget;
    QVBoxLayout *leftLayout;
    QToolBox *leftPanel;

    QWidget *rightSideWidget;
    QVBoxLayout *rightLayout;
    QTabWidget *tabWidget;
    int tabsPosition;
    bool tabsMovable;

    QLabel *avatarIconLabel;
    QString avatarURL;
    QLabel *fullNameLabel;


    QSystemTrayIcon *trayIcon;



    AccountDialog *accountDialog;
    ConfigDialog *configDialog;
    PumpController *pumpController;
    FDNotifications *fdNotifier;

    TimeLine *timeLine;
    int postsPerPage;
    QScrollArea *timeLineScrollArea;
    MessageList *messageList;
    QScrollArea *messageListScrollArea;
    ContactList *contactList;
    QScrollArea *contactListScrollArea;

    Publisher *publisher;
    int publisherType;


    bool firstRun;
    QString dataDirectory; // will have /images and /avatars
    bool reallyQuitProgram;

    int updateInterval;
    QTimer *updateTimer;

    int showNotifications;

    // user account-related data
    QString userID;
    QString userAuth;
    QByteArray ownAvatarData;

    QLabel *aspectListLabel;

};

#endif // MAINWINDOW_H
