/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "mischelpers.h"

MiscHelpers::MiscHelpers(QObject *parent) : QObject(parent)
{
    // Creating object not required
}


QString MiscHelpers::getCachedAvatarFilename(QString url)
{
    QString localFilename;
#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
    localFilename = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
#else
    localFilename = QStandardPaths::standardLocations(QStandardPaths::DataLocation).first();
#endif
    localFilename.append("/avatars/");
    localFilename.append(url.trimmed().toUtf8().toBase64());

    QString fileExtension = url;
    fileExtension.remove(QRegExp(".*\\.")); // remove all but the extension

    localFilename.append(".");
    localFilename.append(fileExtension);

    return localFilename;
}







QString MiscHelpers::getCachedImageFilename(QString url)
{
    QString localFilename;
#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
    localFilename = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
#else
    localFilename = QStandardPaths::standardLocations(QStandardPaths::DataLocation).first();
#endif
    localFilename.append("/images/");
    localFilename.append(url.trimmed().toUtf8().toBase64());


    return localFilename;
}
