/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef POST_H
#define POST_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QTextBrowser>
#include <QLabel>
#include <QIcon>
#include <QPixmap>
#include <QPushButton>
#include <QString>
#include <QStringList>
#include <QMap>
#include <QFile>
#include <QResizeEvent>
#include <QVariantList>
#include <QMessageBox>

#include <QDebug>


#include "markdown.h"
#include "timestamp.h"
#include "mischelpers.h"
#include "pumpcontroller.h"
#include "commenter.h"


class Post : public QFrame
{
    Q_OBJECT

public:
    Post(PumpController *pumpController,
         QMap<QString,QString> postData,
         QVariantList commentsVariantList,
         QWidget *parent = 0);
    ~Post();

signals:

public slots:
    void showNsfwPost();

    void likePost();
    void commentOnPost();
    void sendComment(QString comment);
    void sharePost();
    void deletePost();

protected:
    virtual void resizeEvent(QResizeEvent *event);


private:
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftColumnLayout;
    QVBoxLayout *rightColumnLayout;

    QString postID;
    QString postType;
    bool postIsOwn;

    QLabel *postAuthorAvatar;
    QLabel *postAuthorName;
    QLabel *postCreatedAt;
    QLabel *postTypeLabel;
    QLabel *postRootAuthor;
    QLabel *postLikesCount;
    QLabel *postCommentsCount;
    QLabel *postResharesCount;

    QHBoxLayout *buttonsLayout;
    QPushButton *likeButton;
    QPushButton *commentButton;
    QPushButton *shareButton;
    QPushButton *deleteButton;

    QTextBrowser *postText;

    QPushButton *nsfwCoveringButton;

    QStringList imageList;


    PumpController *pController;
    Commenter *commenter;
};

#endif // POST_H
