/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "publisher.h"

Publisher::Publisher(int publisherType, QWidget *parent) : QWidget(parent)
{
    mainLayout = new QGridLayout();


    composerBox = new Composer();
    connect(composerBox, SIGNAL(focusReceived()),    this, SLOT(setFullMode()));
    connect(composerBox, SIGNAL(editingFinished()),  this, SLOT(share()));
    connect(composerBox, SIGNAL(editingCancelled()), this, SLOT(setMinimumMode()));


    aspectList = new QMenu("to-list");
    aspectList->addAction(tr("Public"))->setCheckable(true);
    aspectList->addAction(tr("Followers"))->setCheckable(true);
    aspectList->addSeparator();
    aspectList->addAction(tr("List 1"))->setCheckable(true);
    aspectList->addAction(tr("List 2"))->setCheckable(true);
    aspectList->addAction(tr("List 3"))->setCheckable(true);


    // Default = "followers"
    aspectList->actions().at(1)->setChecked(true); // VERY, VERY tmp


    aspectSelector = new QPushButton(QIcon::fromTheme("system-users"),
                                     tr("&To...")); // FIXME
    aspectSelector->setToolTip(tr("Select who will see this post"));
    aspectSelector->setMenu(aspectList);


    pictureButton = new QPushButton(QIcon::fromTheme("camera-photo"),
                                    tr("&Picture..."));
    pictureButton->setToolTip(tr("Upload photos"));
    pictureButton->setDisabled(true); // FIXME: until pics can be attached...

    shareButton = new QPushButton(QIcon::fromTheme("mail-send"),
                                  tr("&Post"));
    shareButton->setToolTip(tr("Hit Control+Enter to post with the keyboard"));
    connect(shareButton, SIGNAL(clicked()),  this, SLOT(share()));


    switch (publisherType)
    {
    case 1: // second layout, buttons around
        mainLayout->addWidget(aspectSelector, 0, 0, 1, 1);
        mainLayout->addWidget(pictureButton,  1, 0, 1, 1);
        mainLayout->addWidget(composerBox,    0, 1, 3, 4); // 3 rows, 4 columns
        mainLayout->addWidget(shareButton,    0, 5, 2, 1); // 2 rows
        shareButton->setSizePolicy(QSizePolicy::Maximum,
                                   QSizePolicy::MinimumExpanding);
        break;

    case 2: // Third layout, buttons on right side
        mainLayout->addWidget(composerBox,    0, 0, 2, 3); // 2 rows, 3 columns
        mainLayout->addWidget(aspectSelector, 0, 3, 1, 1);
        mainLayout->addWidget(pictureButton,  1, 3, 1, 1);
        mainLayout->addWidget(shareButton,    0, 4, 2, 1); // 2 rows, 1 column
        shareButton->setSizePolicy(QSizePolicy::Maximum,
                                   QSizePolicy::MinimumExpanding);
        break;


    case 0: // First (default) layout
        // just let it jump to default, so incorrect values go to default

    default:
        mainLayout->addWidget(composerBox,    0, 0, 3, 4); // 3 rows, 4 columns
        mainLayout->addWidget(aspectSelector, 3, 0, 1, 1);
        mainLayout->addWidget(pictureButton,  3, 1, 1, 1, Qt::AlignLeft);
        mainLayout->addWidget(shareButton,    3, 3, 1, 1);

        break;

    }



    this->setLayout(mainLayout);

    this->setMinimumMode();

    qDebug() << "Publisher created";
}




/***************************** SLOTS ********************************/



void Publisher::setMinimumMode()
{
    qDebug() << "setting Publisher to minimum mode";

    this->shareButton->setFocus(); // give focus to button,
                                   // in case user shared with Ctrl+Enter

    // disable possible scrollbars
    this->composerBox->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    this->composerBox->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    // ~1 row
    this->setMaximumHeight((this->composerBox->fontInfo().pixelSize()+4) * 2);
    //qDebug() << this->composerBox->startConversationLabel->height();

    this->aspectSelector->hide();
    this->pictureButton->hide();
    this->shareButton->hide();

    // Clear formatting options like bold, italic and underline
    this->composerBox->setCurrentCharFormat(QTextCharFormat());
}


void Publisher::setFullMode()
{
    qDebug() << "setting Publisher to full mode";

    this->composerBox->setVerticalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    this->composerBox->setHorizontalScrollBarPolicy(Qt::ScrollBarAsNeeded);
    this->setMaximumHeight(2048);  // i.e. "unlimited"

    this->aspectSelector->show();
    this->pictureButton->show();
    this->shareButton->show();

    this->composerBox->setFocus(); // In case user used menu or shortcut
                                   // instead of clicking on it
}



void Publisher::share()
{
    qDebug() << "Publisher character count:" << composerBox->textCursor().document()->characterCount();

    // If there's some text in the post, send it
    if (composerBox->textCursor().document()->characterCount() > 1)  // kinda tmp
    {
        QString scapedHtml = composerBox->toHtml();
        // We no longer need to escape the quotes, since the QJson serializer takes care of that
        ////scapedHtml.replace("\"", "\\\""); // Escape the quotes
        scapedHtml.replace("\n", " ");    // Remove line breaks, as that results in server error 500


        // Kinda tmp cleanup of HTML stuff
        QRegExp headRE("<html><head>.*</head>");
        headRE.setMinimal(true);
        scapedHtml.remove(headRE);
        scapedHtml.remove("</body></html>");

        QRegExp bodyRE("<body style.*>");
        bodyRE.setMinimal(true);
        scapedHtml.remove(bodyRE);


        emit sharePost(scapedHtml);             // TODO: more params

        // FIXME: in the future, it will be possible to leave empty,
        // if there are attached pictures

        this->composerBox->erase();

        // Done composing message, hide buttons until we get focus again
        setMinimumMode();
    }
    else
    {
        qDebug() << "can't share, text is empty";
    }
}
