/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef COMMENTER_H
#define COMMENTER_H

#include <QWidget>
#include <QGridLayout>
#include <QTextBrowser>
#include <QPushButton>

#include "pumpcontroller.h"
#include "composer.h"
#include "mischelpers.h"
#include "timestamp.h"

class Commenter : public QWidget
{
    Q_OBJECT

public:
    explicit Commenter(PumpController *pumpController, QWidget *parent = 0);
    ~Commenter();

    void setComments(QVariantList commentsList);
    
signals:
    void commentSent(QString comment);
    void allCommentsRequested();

    
public slots:
    void setMinimumMode();
    void setFullMode();

    void requestAllComments();

    void sendComment();

private:
    QGridLayout *mainLayout;

    QTextBrowser *commentsTextBrowser;
    QPushButton *showAllCommentsButton;


    Composer *commentComposer;
    QPushButton *commentButton;
    QPushButton *cancelButton;


    PumpController *pController;
};

#endif // COMMENTER_H
