/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef CONTACTCARD_H
#define CONTACTCARD_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QIcon>
#include <QString>
#include <QMap>
#include <QFont>
#include <QFile>
#include <QPushButton>
#include <QMenu>
#include <QMessageBox>

#include <QDebug>

#include "mischelpers.h"
#include "pumpcontroller.h"


class ContactCard : public QFrame
{
    Q_OBJECT

public:
    ContactCard(PumpController *pumpController,
                QMap<QString,QString> contactData,
                QWidget *parent = 0);
    ~ContactCard();

    void setButtonToFollow();
    void setButtonToUnfollow();

signals:

public slots:
    void followContact();
    void unfollowContact();

    void openProfileInBrowser();

    void redrawAvatar(QString avatarUrl, QString avatarFilename);


private:
    QHBoxLayout *mainLayout;
    QVBoxLayout *centerLayout;
    QVBoxLayout *rightLayout;

    QLabel *avatarLabel;
    QLabel *nameLabel;

    QLabel *userInfoLabel;

    QPushButton *followButton;
    QPushButton *optionsButton;
    QMenu *optionsMenu;
    QAction *openProfileAction;
    QMenu *addToListMenu;


    PumpController *pController;
    QString contactID;
    QString contactURL;
    QString contactAvatarUrl;
};

#endif // CONTACTCARD_H
