/*
 *   This file is part of Dianara
 *   Copyright 2012-2013  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "minorfeed.h"


MinorFeed::MinorFeed(PumpController *pumpController,
                     QWidget *parent) : QFrame(parent)
{
    this->pController = pumpController;
    this->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);

    mainLayout = new QVBoxLayout();
    mainLayout->setAlignment(Qt::AlignTop);
    this->setLayout(mainLayout);

    MinorFeedItem *demoFeedItem = new MinorFeedItem(QDateTime::currentDateTimeUtc()
                                                              .toString(Qt::ISODate),
                                                    "Dianara",
                                                    tr("There are no activities to show yet."),
                                                    "",
                                                    "",
                                                    "");
    this->mainLayout->addWidget(demoFeedItem);
    this->itemsInFeed.append(demoFeedItem);


    qDebug() << "MinorFeed created";
}


MinorFeed::~MinorFeed()
{
    qDebug() << "MinorFeed destroyed";
}


void MinorFeed::clearContents()
{
    qDebug() << "MinorFeed::clearContents()";
    foreach (MinorFeedItem *feedItem, itemsInFeed)
    {
        feedItem->deleteLater();
    }

    itemsInFeed.clear();
}



/*******************************************************************************/
/********************************** SLOTS **************************************/
/*******************************************************************************/


void MinorFeed::updateFeed()
{
    this->pController->getMinorFeed();
}



void MinorFeed::setFeedContents(QVariantList activitiesList)
{
    this->clearContents();

    QString activityTime;
    QString activityGenerator;
    QString activityDescription;
    QString activityObjectContent;
    QString activityObjectAuthor;
    QString activityActorAvatarURL;
    QString activityActorAvatarFilename;


    foreach (QVariant activityVariant, activitiesList)
    {
        QVariantMap activityMap = activityVariant.toMap();

        activityTime = activityMap.value("updated").toString();
        activityGenerator = activityMap.value("generator").toMap().value("displayName").toString();
        activityDescription = activityMap.value("content").toString();

        activityActorAvatarURL = activityMap.value("actor").toMap().value("image").toMap().value("url").toString();
        activityActorAvatarFilename = MiscHelpers::getCachedAvatarFilename(activityActorAvatarURL);
        if (!QFile::exists(activityActorAvatarFilename))
        {
            this->pController->getAvatar(activityActorAvatarURL);
        }

        activityObjectContent = activityMap.value("object").toMap().value("content").toString();
        activityObjectAuthor = activityMap.value("object").toMap().value("author").toMap().value("displayName").toString();


        MinorFeedItem *newFeedItem = new MinorFeedItem(activityTime,
                                                       activityGenerator,
                                                       activityDescription,
                                                       activityActorAvatarFilename,
                                                       activityObjectAuthor,
                                                       activityObjectContent);
        this->mainLayout->addWidget(newFeedItem);
        this->itemsInFeed.append(newFeedItem);
    }

}

