/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include <QApplication>
#include <QTranslator>
#include <iostream>

#include "mainwindow.h"





#if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
void customMessageHandlerQt4(QtMsgType type, const char *msg)
{
    // do nothing
    Q_UNUSED(type)
    Q_UNUSED(msg)  // FIXME, memory leak?

    return;
}
#else
void customMessageHandlerQt5(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
    Q_UNUSED(type)
    Q_UNUSED(context)
    Q_UNUSED(msg)

    // Do nothing

    return;
}
#endif



int main(int argc, char *argv[])
{
    QApplication dianaraApp(argc, argv);
    dianaraApp.setApplicationName("Dianara");
    dianaraApp.setApplicationVersion("1.2.0");
    dianaraApp.setOrganizationName("JanCoding");
    dianaraApp.setOrganizationDomain("jancoding.wordpress.com");

    std::cout << QString("%1 v%2 - JanKusanagi 2012-2014\n\n")
                     .arg(dianaraApp.applicationName())
                     .arg(dianaraApp.applicationVersion()).toStdString();
    std::cout << QString("Built with Qt v%1\n").arg(qVersion()).toStdString();
    std::cout << QString("Running with Qt v%1\n\n").arg(QT_VERSION_STR).toStdString();
    std::cout.flush();

    // To make the mswin version of Dianara distributable as a standalone package
#ifdef Q_OS_WIN
    dianaraApp.addLibraryPath("./plugins/");
#endif

    // Register custom message handler, to hide debug messages unless specified
    if (qApp->arguments().contains("--debug", Qt::CaseInsensitive))
    {
        qDebug() << "Debug messages enabled";
    }
    else
    {
    #ifdef Q_OS_WIN
        FreeConsole();
    #endif

        qDebug() << "To see debug messages while running, use --debug";
    #if QT_VERSION < QT_VERSION_CHECK(5, 0, 0)
        qInstallMsgHandler(customMessageHandlerQt4);
    #else
        qInstallMessageHandler(customMessageHandlerQt5);
    #endif
    }


    // Load translation files
    QTranslator translator;
    // Get language from LANG environment variable or system's locale
    QString languageString = qgetenv("LANG");
    if (languageString.isEmpty())
    {
        languageString = QLocale::system().name();
    }
    QString languageFile;
    languageFile = QString(":/translations/dianara_%1")
                   .arg(languageString);
    qDebug() << "Trying to load translation file:" << languageFile;

    translator.load(languageFile);
    dianaraApp.installTranslator(&translator);


    MainWindow dianaraWindow;
    dianaraWindow.toggleMainWindow();  // show()


    return dianaraApp.exec();
}
