/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef POST_H
#define POST_H

#include <QFrame>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QTextBrowser>
//#include <QTextBlock>
//#include <QAbstractTextDocumentLayout>
#include <QLabel>
#include <QIcon>
#include <QPixmap>
#include <QPushButton>
#include <QString>
#include <QStringList>
#include <QMap>
#include <QFile>
#include <QVariantList>
#include <QMessageBox>
#include <QTimer>
#include <QSettings>

#include <QDebug>


#include "timestamp.h"
#include "mischelpers.h"
#include "pumpcontroller.h"
#include "commenterblock.h"
#include "imageviewer.h"
#include "asactivity.h"
#include "avatarbutton.h"

class Post : public QFrame
{
    Q_OBJECT

public:
    Post(ASActivity *activity,
         QStringList highlightColors,
         bool highlightedByFilter,
         bool isStandalone,
         PumpController *pumpController,
         QWidget *parent);
    ~Post();


    void setMinMaxHeight(int newMinMaxHeight);

    void setPostContents();
    void setPostHeight();
    void resetResizesCount();
    void getPendingImages();

    QString likesURL();
    void setLikes(QVariantList likesList, int likesCount=-1);
    void setLikesLabel(int likesCount);

    QString commentsURL();
    void setComments(QVariantList commentsList);
    void setCommentsLabel(int commentsCount);

    QString sharesURL();
    void setShares(QVariantList sharesList, int sharesCount=-1);
    void setSharesLabel(int resharesCount);

    void setPostUnreadStatus();
    void setPostAsNew();
    void setPostAsRead();

    int getHighlightType();

    void setFuzzyTimestamps();

    enum PostHightlightType
    {
        NoHighlight = -1,
        MessageForUserHighlight,
        OwnMessageHighlight,
        FilterRulesHighlight
    };


signals:
    void postRead();
    void postEditRequested(QString originalPostID,
                           QString contents,
                           QString title);
    void commentingOnPost(QWidget *commenterWidget);


public slots:
    void likePost(bool like);
    void fixLikeButton(QString state);
    void getAllLikes();

    void commentOnPost();
    void sendComment(QString commentText);
    void updateComment(QString commentId, QString commentText);

    void getAllComments();
    void setAllComments(QVariantList commentsList,
                        QString originatingPostUrl);

    void sharePost();
    void unsharePost();

    void editPost();

    void deletePost();

    void openClickedURL(QUrl url);
    void showHighlightedUrl(QString url);


    void openPostInBrowser();
    void copyPostUrlToClipboard();
    void normalizeTextFormat();

    void triggerResize();

    void redrawImages(QString imageUrl);


protected:
    virtual void resizeEvent(QResizeEvent *event);
    virtual void mousePressEvent(QMouseEvent *event);
    virtual void leaveEvent(QEvent *event);
    virtual void closeEvent(QCloseEvent *event);
    virtual void keyPressEvent(QKeyEvent *event);


private:
    QHBoxLayout *mainLayout;
    QVBoxLayout *leftColumnLayout;
    QVBoxLayout *rightColumnLayout;

    QFrame *leftColumnFrame;

    QString postId;
    QString postType;
    QString postUrl;
    QString postAuthorName;

    QString postSharedById;
    QString sharedByTooltipString;
    QString sharedByGeneratorString;
    QString shareTime;

    bool postIsOwn;
    bool postIsUnread;
    int highlightType;

    AvatarButton *postAuthorAvatarButton;
    QAction *openPostInBrowserAction;
    QAction *copyPostUrlAction;
    QAction *normalizeTextAction;

    QLabel *postAuthorNameLabel;
    QLabel *postCreatedAtLabel;
    QLabel *postLocationLabel;
    QLabel *postToLabel;
    QLabel *postCCLabel;
    QLabel *postIsSharedLabel;

    QLabel *postLikesCountLabel;
    QLabel *postCommentsCountLabel;
    QLabel *postResharesCountLabel;


    QLabel *postTitleLabel;
    QTextBrowser *postText;

    QHBoxLayout *buttonsLayout;
    QPushButton *likeButton;
    QPushButton *commentButton;
    QPushButton *shareButton;

    QPushButton *editButton;
    QPushButton *deleteButton;

    QString postTitle;
    QString postImageUrl;
    QString postAudioUrl;
    QString postVideoUrl;
    QString postFileUrl;
    QString postOriginalText;

    QString postCreatedAtString;
    QString postUpdatedAtString;

    int postWidth;
    int minMaxHeight;

    int resizesCount;

    QString postLikesUrl;
    QString postCommentsUrl;
    QString postSharesUrl;

    QStringList pendingImagesList;

    bool standalone;

    QString seeFullImageString;

    PumpController *pController;
    CommenterBlock *commenter;
};

#endif // POST_H
