/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "asobject.h"

ASObject::ASObject(QVariantMap objectMap,
                   QObject *parent) : QObject(parent)
{
    this->originalObjectMap = objectMap;

    /// Meta information
    id = objectMap.value("id").toString();
    if (id.startsWith("acct:"))
    {
        id.remove(0,5);
    }

    type = objectMap.value("objectType").toString();
    url = objectMap.value("url").toString();
    createdAt = objectMap.value("published").toString();
    updatedAt = objectMap.value("updated").toString();

    // FIXME: kind of basic...
    location = objectMap.value("location").toMap().value("displayName").toString();


    // Author
    this->asAuthor = new ASPerson(objectMap.value("author").toMap(), this);

    // This will hold the date when the object was deleted, or empty if it wasn't
    deleted = objectMap.value("deleted").toString();

    liked = objectMap.value("liked").toString();

    // The object to which this one replies, if any (note to which a comment replies, etc)
    inReplyToMap = objectMap.value("inReplyTo").toMap();


    ///
    /// End of "meta"; Start of content
    ///


    if (type == "image")
    {
        // See if there's a proxy URL for the image first (for private images)
        imageUrl = objectMap.value("fullImage").toMap().value("pump_io").toMap().value("proxyURL").toString();
        qDebug() << "Trying Proxyed fullImage";

        // if that's empty, try the "small" version
        if (imageUrl.isEmpty())
        {
            qDebug() << "Trying Proxyed thumbnail image";
            imageUrl = objectMap.value("image").toMap().value("pump_io").toMap().value("proxyURL").toString();
        }

        // If that's also empty, use regular fullImage->url field
        if (imageUrl.isEmpty())
        {
            qDebug() << "Trying direct fullImage";
            imageUrl = objectMap.value("fullImage").toMap().value("url").toString();
        }

        // And if that is ALSO empty, use regular image->url
        if (imageUrl.isEmpty())
        {
            qDebug() << "Trying direct thumbnail image";
            imageUrl = objectMap.value("image").toMap().value("url").toString();
        }
        qDebug() << "postImage:" << imageUrl;
    }


    // Get audio file URL
    if (type == "audio")
    {
        audioUrl = objectMap.value("stream").toMap().value("pump_io").toMap().value("proxyURL").toString();
        if (audioUrl.isEmpty())
        {
            qDebug() << "No proxyed link to audio, fetching regular link";
            audioUrl = objectMap.value("stream").toMap().value("url").toString();
        }
    }

    // Get video file URL
    if (type == "video")
    {
        videoUrl = objectMap.value("stream").toMap().value("pump_io").toMap().value("proxyURL").toString();
        if (videoUrl.isEmpty())
        {
            qDebug() << "No proxyed link to video, fetching regular link";
            videoUrl = objectMap.value("stream").toMap().value("url").toString();
        }
    }

    // Get general file URL
    if (type == "file")
    {
        fileUrl = objectMap.value("fileUrl").toMap().value("pump_io").toMap().value("proxyURL").toString();
        if (fileUrl.isEmpty())
        {
            qDebug() << "No proxyed link to general file, fetching regular link";
            fileUrl = objectMap.value("fileUrl").toString();
        }

        mimeType = objectMap.value("mimeType").toString();
        qDebug() << "file mimeType:" << mimeType;
    }


    // Title can be in non-image posts, too!
    title = objectMap.value("displayName").toString();
    content = objectMap.value("content").toString();

    likesCount = objectMap.value("likes").toMap().value("totalItems").toString();
    commentsCount = objectMap.value("replies").toMap().value("totalItems").toString();
    sharesCount = objectMap.value("shares").toMap().value("totalItems").toString();

    // Get last likes, comments and shares list here, used from Post()
    lastLikesList = objectMap.value("likes").toMap().value("items").toList();
    lastCommentsList = objectMap.value("replies").toMap().value("items").toList();
    lastSharesList = objectMap.value("shares").toMap().value("items").toList();

    // Get URL for likes; first, proxyURL if it exists
    likesUrl = objectMap.value("likes").toMap().value("pump_io").toMap().value("proxyURL").toString();
    // If still empty, get regular URL (that means the post is in the same server we are)
    if (likesUrl.isEmpty())
    {
        likesUrl = objectMap.value("likes").toMap().value("url").toString();
    }

    // Get URL for comments; first, proxyURL if it exists
    commentsUrl = objectMap.value("replies").toMap().value("pump_io").toMap().value("proxyURL").toString();
    if (commentsUrl.isEmpty()) // If still empty, get regular URL
    {
        commentsUrl = objectMap.value("replies").toMap().value("url").toString();
    }

    // FIXME: get sharesUrl...

    qDebug() << "ASObject created" << this->id;
}

ASObject::~ASObject()
{
    qDebug() << "ASObject destroyed" << this->id;
}



/////// Getters

ASPerson *ASObject::author()
{
    return this->asAuthor;
}

QString ASObject::getId()
{
    return this->id;
}

QString ASObject::getType()
{
    return this->type;
}

QString ASObject::getUrl()
{
    return this->url;
}

QString ASObject::getCreatedAt()
{
    return this->createdAt;
}

QString ASObject::getUpdatedAt()
{
    return this->updatedAt;
}

QString ASObject::getLocation()
{
    return this->location;
}


QString ASObject::getDeletedTime()
{
    return this->deleted;
}

QString ASObject::isLiked()
{
    return this->liked;
}


QString ASObject::getTitle()
{
    return this->title;
}

QString ASObject::getContent()
{
    return this->content;
}

QString ASObject::getImageUrl()
{
    return this->imageUrl;
}

QString ASObject::getAudioUrl()
{
    return this->audioUrl;
}

QString ASObject::getVideoUrl()
{
    return this->videoUrl;
}

QString ASObject::getFileUrl()
{
    return this->fileUrl;
}

QString ASObject::getMimeType()
{
    return this->mimeType;
}

QString ASObject::getLikesCount()
{
    return this->likesCount;
}

QString ASObject::getCommentsCount()
{
    return this->commentsCount;
}

QString ASObject::getSharesCount()
{
    return this->sharesCount;
}

QVariantList ASObject::getLastLikesList()
{
    return this->lastLikesList;
}

QVariantList ASObject::getLastCommentsList()
{
    return this->lastCommentsList;
}

QVariantList ASObject::getLastSharesList()
{
    return this->lastSharesList;
}

QString ASObject::getLikesUrl()
{
    return this->likesUrl;
}

QString ASObject::getCommentsUrl()
{
    return this->commentsUrl;
}

QString ASObject::getSharesUrl()
{
    return this->sharesUrl;
}

QVariantMap ASObject::getOriginalObject()
{
    return this->originalObjectMap;
}

QVariantMap ASObject::getInReplyTo()
{
    return this->inReplyToMap;
}
