/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi <janjabber@gmail.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <QMainWindow>
#include <QApplication>
#include <QSettings>
#include <QMenuBar>
#include <QToolBar>
#include <QStatusBar>
#include <QSystemTrayIcon>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QToolBox>
#include <QTabWidget>
#include <QLabel>
#include <QCloseEvent>
#include <QByteArray>
#include <QPixmap>
#include <QMessageBox>
#include <QDir>
#include <QTimer>
#include <QScrollArea>
#include <QScrollBar>
#include <QVariantList>
#include <QDesktopServices>
#if QT_VERSION >= QT_VERSION_CHECK(5, 0, 0)
#include <QStandardPaths>
#endif
#include <QTime>
#include <QSplitter>
#include <QPainter>

#include <QDebug>

#include "accountdialog.h"
#include "configdialog.h"
#include "pumpcontroller.h"
#include "notifications.h"
#include "publisher.h"
#include "timeline.h"
#include "post.h"
#include "contactmanager.h"
#include "minorfeed.h"
#include "profileeditor.h"
#include "filtereditor.h"
#include "filterchecker.h"
#include "logviewer.h"


class MainWindow : public QMainWindow
{
    Q_OBJECT


public:    
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

    void prepareDataDirectory();
    void createMenus();
    void createToolbar();
    void createStatusbarWidgets();
    void createTrayIcon();
    void setTrayIconPixmap(int count = 0);

    void loadSettings();
    void saveSettings();


public slots:
    void updateUserID(QString newUserID);
    void updateConfigSettings();

    void toggleWidgetsByAuthorization(bool authorized);

    void trayControl(QSystemTrayIcon::ActivationReason reason);
    void showTrayFallbackMessage(QString message);

    void updateProfileData(QString avatarUrl, QString fullName,
                           QString hometown, QString bio,
                           QString eMail);

    void updateAllTimelines();
    void updateMainDirectMinorTimelines();
    void updateMainActivityMinorTimelines();

    void scrollMainTimelineTo(QAbstractSlider::SliderAction sliderAction);
    void scrollDirectTimelineTo(QAbstractSlider::SliderAction sliderAction);
    void scrollActivityTimelineTo(QAbstractSlider::SliderAction sliderAction);
    void scrollFavoritesTimelineTo(QAbstractSlider::SliderAction sliderAction);

    void scrollMainTimelineToWidget(QWidget *widget);
    void scrollDirectTimelineToWidget(QWidget *widget);
    void scrollActivityTimelineToWidget(QWidget *widget);
    void scrollFavoritesTimelineToWidget(QWidget *widget);

    void notifyTimelineUpdate(int timelineType,
                              int newPostCount,
                              int highlightCount);
    void setTimelineTabTitle(int timelineType,
                             int newPostCount,
                             int highlightCount);

    void setTitleAndTrayInfo(int currentTab);
    void setMinorFeedTitle(int newItemsCount);
    void notifyMinorFeedUpdate(int newItemsCount, int highlightedCount);

    void storeAvatar(QByteArray avatarData, QUrl avatarUrl);
    void storeImage(QByteArray imageData, QUrl imageUrl);

    void setStatusBarMessage(QString message);
    void setTransientStatusMessage(QString message);

    void markAllAsRead();
    void refreshAllTimestamps();
    void adjustTimelineSizes();
    void onSplitterMoved();


    void toggleSidePanel(bool shown);
    void toggleToolbar(bool shown);
    void toggleStatusBar(bool shown);
    void toggleFullscreen(bool enabled);


    void visitWebSite();
    void visitFAQ();
    void visitTips();
    void aboutDianara();

    void toggleMainWindow();

    void quitProgram();


protected:
    virtual void closeEvent(QCloseEvent *event);
    virtual void resizeEvent(QResizeEvent *event);


private:
    ////////////////////////////////////// Menus
    QMenu *sessionMenu;
    QMenu *viewMenu;
    QMenu *settingsMenu;
    QMenu *helpMenu;

    QMenu *trayContextMenu;
    QAction *trayShowWindowAction;

    QAction *sessionUpdateMainTimeline;
    QAction *sessionUpdateDirectTimeline;
    QAction *sessionUpdateActivityTimeline;
    QAction *sessionUpdateFavoritesTimeline;
    QAction *sessionUpdateMinorFeed;
    QAction *sessionUpdateAllTimelines;
    QAction *sessionMarkAllAsRead;
    QAction *sessionPostNote;
    QAction *sessionQuit;

    QAction *viewSidePanel;
    QAction *viewToolbar;
    QAction *viewStatusBar;
    QAction *viewFullscreenAction;
    QAction *viewLogAction;

    QAction *settingsEditProfile;
    QAction *settingsAccount;
    QAction *settingsFilters;
    QAction *settingsConfigure;

    QAction *helpVisitWebsite;
    QAction *helpVisitPumpFAQ;
    QAction *helpVisitPumpTips;
    QAction *helpAbout;
    ////////////////////////////////////// End menus

    // Toolbar
    QToolBar *mainToolBar;

    // Statusbar widgets
    QToolButton *statusLogButton;


    QSplitter *mainSplitter;

    QWidget *leftSideWidget;
    QVBoxLayout *leftLayout;

    QHBoxLayout *leftTopLayout;
    QVBoxLayout *userInfoLayout;
    QToolBox *leftPanel;

    QWidget *rightSideWidget;
    QVBoxLayout *rightLayout;
    QTabWidget *tabWidget;
    int tabsPosition;
    bool tabsMovable;

    QPushButton *avatarIconButton;
    QString avatarURL;
    QLabel *fullNameLabel;
    QLabel *userIdLabel;
    QLabel *userHometownLabel;


    QSystemTrayIcon *trayIcon;
    bool trayIconAvailable;
    int trayIconType;
    QPixmap trayCustomPixmap;
    int trayCurrentCount;



    AccountDialog *accountDialog;
    ProfileEditor *profileEditor;
    ConfigDialog *configDialog;
    FilterChecker *filterChecker;
    FilterEditor *filterEditor;
    LogViewer *logViewer;
    PumpController *pumpController;
    FDNotifications *fdNotifier;

    MinorFeed *meanwhileFeed;

    int postsPerPageMain;
    TimeLine *mainTimeline;
    QScrollArea *mainTimelineScrollArea;

    int postsPerPageOther;
    TimeLine *directTimeline;
    QScrollArea *directTimelineScrollArea;

    TimeLine *activityTimeline;
    QScrollArea *activityTimelineScrollArea;

    TimeLine *favoritesTimeline;
    QScrollArea *favoritesTimelineScrollArea;


    ContactManager *contactManager;

    Publisher *publisher;


    bool firstRun;
    QString dataDirectory; // will have /images and /avatars
    bool reallyQuitProgram;

    int updateInterval;
    QTimer *updateTimer;

    QTimer *timestampsTimer;
    QTimer *delayedResizeTimer;

    bool publicPosts;

    QString oldStatusBarMessage;

    // user account-related data
    QString userID;

};

#endif // MAINWINDOW_H
