/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#ifndef GLOBALOBJECT_H
#define GLOBALOBJECT_H

#include <QObject>
#include <QSettings>
#include <QFont>
#include <QStringList>

#include <QDebug>


class GlobalObject : public QObject
{
    Q_OBJECT

public:
    explicit GlobalObject(QObject *parent = 0);
    ~GlobalObject();


    void syncGeneralSettings(int minorFeedSnippets, int snippetsChars);
    int getMinorFeedSnippetsType();
    int getSnippetsCharLimit();


    void syncFontSettings(QString postTitleFont,
                          QString postContentsFont,
                          QString commentsFont,
                          QString minorFeedFont);
    QString getPostTitleFont();
    QString getPostContentsFont();
    QString getCommentsFont();
    QString getMinorFeedFont();


    void syncColorSettings(QStringList newColorList);
    QStringList getColorsList();


    void createMessageForContact(QString name, QString id);
    void editPost(QString originalPostId,
                  QString title,
                  QString contents);




signals:
    void messagingModeRequested(QString name, QString id);
    void postEditRequested(QString originalPostId,
                           QString title,
                           QString contents);



public slots:


private:
    int minorFeedSnippetsType;
    int snippetsCharLimit;

    QString postTitleFontInfo;
    QString postContentsFontInfo;
    QString commentsFontInfo;
    QString minorFeedFontInfo;

    QStringList colorsList;
};

#endif // GLOBALOBJECT_H
