/*
 *   This file is part of Dianara
 *   Copyright 2012-2014  JanKusanagi JRR <jancoding@gmx.com>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .
 */

#include "hclabel.h"


HClabel::HClabel(QString initialText,
                 QWidget *parent) : QLabel(parent)
{
    this->setWordWrap(true);
    this->setAutoFillBackground(true);

    this->setText(initialText);

    this->setHighlighted(false); // Default

    qDebug() << "HClabel created";
}

HClabel::~HClabel()
{
    qDebug() << "HClabel destroyed";
}


void HClabel::setHighlighted(bool highlighted)
{
    if (highlighted)
    {
        // Constant highlighting
        this->setStyleSheet("QLabel "
                            "{ color: palette(highlighted-text);   "
                            "  background-color: palette(highlight)"
                            "}"
                            "QLabel:hover "
                            "{ color: palette(text);               "
                            "  background-color: palette(highlight)"
                            "}");
    }
    else
    {
        // Highlight only on mouse hover
        this->setStyleSheet("QLabel "
                            "{ background-color: transparent }"
                            "QLabel:hover "
                            "{ background-color: palette(highlight) }");
    }
}
