/*****************************************************************************************/
/* Copyright 2008,2009,2010,2011,2012 Elias Potapov. */
/* Copyright 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007
   The GSL Team. */

/*****************************************************************************************/
/* This file is part of DINAMICA. */

/* DINAMICA is free software: you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation, either version 3 of the License, or */
/* (at your option) any later version. */

/* DINAMICA is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with DINAMICA.  If not, see <http://www.gnu.org/licenses/>. */
/****************************************************************************************/
/****************************************************************************************/
/* Original author is Elias Potapov <elias.potapov@gmail.com>
   Lomonosov Moscow State University, Biophysics Dep..
   Tampere University of Technology, Dep. of Signal Processing.
   Moscow, Russia / Tampere, Finland
*/
/****************************************************************************************/
/* This file contains routines for operations on data files comprising */
/* time series (usually) like converting to other file formats, split */
/* data sets into different files etc */
#include "init.h"
#include <string.h>
#define MAX_N_DIG 20 /* min 20 */

int *get_info_data(int *info, FILE *input)
{/* The function reads the input from *input and gets the technical information of
    the timeseries stored in the source, like number of simulation runs(nRuns) stored
    and if there was a complex run(complex) or it was a pure deterministic
    traj(pure_det). input must be opend from elsewhere. It returns the array of
    integers, position of each flag/number is pre-defined. */

  char *tmp = malloc((DIM+1)*MAX_N_DIG*sizeof(char));
  char *p = tmp;
  int col = 0;
  /* The info is 4 numbers */
  info = (int *)malloc(4*sizeof(int));
  /* Check if input is opened. */
  if(input == NULL){
    fprintf(stderr,"Error: perhaps no file was opened.\n");
    return NULL;
  }
  else{/* input is O.K. */
    fgets(tmp,(DIM+1)*MAX_N_DIG-1,input);/* Take the line */
    if((*tmp) != '#'){
      fprintf(stderr,"Error: no configuration line, old format data.\n");
      return NULL;
    }
    else if((strchr(tmp,'\n')) == NULL){
      fprintf(stderr,"Error: I could not read the whole line.\n");
      return NULL;
    }
    else{
      tmp++;/* Move away from the first '#' */
      while((*p) != '\n'){/* Loop until first newline */
	if((*p) == ','){
	  (*p) = 0;
	  info[col++] = atoi(tmp);
	  tmp = p + 1;
	}
	p++;
      }
      if((*p) == '\n'){
	(*p) = 0;
	info[col] = atoi(tmp);
      }
    }
  }
  return info;
}

int convert_data_file(char const *filename, int short ff)
{/* filename -- data file name; ff is file format to convert to. ff can */
  /* be: ff=1 -> csv(comma separated data file*/
  /* ff=2 -> TBD*/
  /* NOTE: default DINAMICA format is space separated data file and 2
     newlines (\n) separated data sets. */
  /* ndata -- number of data sets to read, is to be determined from the data source
     information line. The numbering goes from <filename>-I<.csv>, where I goes from
     0 to (ndata-1)*/
  /* The output is written to hard drive. If method is complex, the deterministic
     output is not numbered, i.e. <filename>.csv. */
  int i,outfn_count = 0,newline_count = 0;
  int *info;
  int ndata;
  char *ext;/* extension of the output */
  FILE *in,*out;
  in = fopen(filename,"r");
  if(in==NULL){
    fprintf(stderr,"Error: no file with name `%s'\n",filename);
    return 100;
  }
  if((info=get_info_data(info,in)) == NULL){
    fprintf(stderr,"Error: could not read the data information.\n");
    return 199;
  }
  else{
    /* complex flag + nRuns is the total number of data sets in the source */
    ndata = info[0] + info[1];
  }
  /*** Separator and extension strings ***/
  char *sep;
  if(ff==1){
    sep = ",";
    ext = ".csv";
  }
  else {
    fprintf(stderr,"Error: dont know the format\n");
    return 10;
  }
  /* Allocating temporary and filename strings */
  /* DIM+1 variables written as "%.5lf" meaning at min 7 digits/symbols, we put
     MAX_N_DIG that is to be 20 at min for certainty */
  char *tmp = (char *)malloc((DIM+1)*MAX_N_DIG*sizeof(char));
  /* Output filename, e.g. original name appended with ".csv"*/
  char *outfn = (char *)malloc((strlen(filename)+10)*sizeof(char));
  if(ndata == 1){
    if(ff==1){
      strcpy(outfn,filename);
      strcat(outfn,ext);
    }
    out = fopen(outfn,"w");
    printf("Converting from `%s' to `%s'\n",filename,outfn);
    /* Printing variables to the header of the output */
    fprintf(out,"Time,");
    for(i=0;i<DIM;i++){
      fprintf(out,"%s,",var_name[i]);
    }
    fprintf(out,"\n");
    /* Start actual transfer */
    while((fgets(tmp,(DIM+1)*MAX_N_DIG,in))!=NULL){
      if((strchr(tmp,'\n')) == NULL){
	fprintf(stderr,"Error: could not get whole line.\n");
	return 101;
      }
      for(i=0;i<strlen(tmp);i++){
	if(tmp[i]==' ')/* Default space separator changed to `sep' */
	  fprintf(out,"%s",sep);
	else
	  fprintf(out,"%c",tmp[i]);
      }
    }
    fclose(out);
  }
  else{/* More than 1 data sets in the source: stoch or complex */
    printf("Converting from `%s' to ",filename);
    outfn = (char *)realloc(outfn,
			    (strlen(filename)+20)*sizeof(char));
    while(outfn_count < ndata){
      /* FORMING OUTPUT FILENAMES */
      if((outfn_count==0) && (info[0])){
	/* Determ data set */
	strcpy(outfn,filename);
	strcat(outfn,ext);
      }
      else{
	/* Stoch sets */
	strcpy(outfn,filename);
	sprintf(tmp,"-%d",(outfn_count-info[0]));
	strcat(outfn,tmp);
	strcat(outfn,ext);
      }
      /* ******************* */
      out = fopen(outfn,"w");
      printf("`%s'\n",outfn);
      /* Printing variables to the header of the output */
      fprintf(out,"Time,");
      for(i=0;i<DIM;i++){
	fprintf(out,"%s,",var_name[i]);
      }
      fprintf(out,"\n");
      while((fgets(tmp,(DIM+1)*MAX_N_DIG,in))!=NULL){
	if((strchr(tmp,'\n')) == NULL){
	  fprintf(stderr,"Error: could not get whole line.\n");
	  return 101;
	}
	if((strlen(tmp)==1) || (tmp[0]=='#')){
	  /* Just newline or comment*/
	  newline_count++;
	  continue;/* Skip the rest */
	}
	if(newline_count==2){
	  /* Final condition for a data set, 2 newlines must be in
	     a row in the data file */
	  newline_count = 0;
	  fclose(out);
	  break;
	}
	newline_count = 0;/* Only 2 newlines in a row count */
	for(i=0;i<strlen(tmp);i++){
	  if(tmp[i]==' ')
	    fprintf(out,"%s",sep);
	  else
	    fprintf(out,"%c",tmp[i]);
	}
      }
      outfn_count++;
    }
  }
  fclose(in);
  free(tmp);free(outfn);
  
  return 0;
}
