/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#include "terminal.hpp"


using namespace Gdk;
using namespace Gtk;
using namespace sigc;
using namespace std;


Terminal::Terminal() : m_gobj((VteTerminal*)vte_terminal_new()) {
  
}


Terminal::~Terminal() {
  
}


pid_t Terminal::fork_command(const string& command, char** argv, 
                             char** env, const string& directory, 
                             bool lastlog, bool utmp, bool wtmp) {
  return vte_terminal_fork_command(m_gobj, command.c_str(), argv, env,
                                   (directory == "" ? NULL : directory.c_str()),
                                   lastlog, utmp, wtmp);
}


pid_t Terminal::forkpty(char** env, const string& directory, 
                        bool lastlog, bool utmp, bool wtmp) {
  return vte_terminal_forkpty(m_gobj, env,
                              (directory == "" ? NULL : directory.c_str()),
                              lastlog, utmp, wtmp);
}


void Terminal::feed(const string& data) {
  vte_terminal_feed(m_gobj, data.c_str(), data.size());
}


void Terminal::set_color_background(const Color& color) {
  vte_terminal_set_color_background(m_gobj, color.gobj());
}


void Terminal::set_background_transparent(bool transparent) {
  vte_terminal_set_background_transparent(m_gobj, transparent);
}
