/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#ifndef TERMINAL_HPP
#define TERMINAL_HPP

#include <string>

#include <gtkmm.h>
#include <vte/vte.h>


class Terminal {
public:
  Terminal();
  ~Terminal();
  
  pid_t fork_command(const std::string& command, char** argv, 
                     char** env = NULL, const std::string& directory = "", 
                     bool lastlog = false, bool utmp = false, 
                     bool wtmp = false);
  
  pid_t forkpty(char** env = NULL, const std::string& directory = "", 
                bool lastlog = false, bool utmp = false, bool wtmp = false);
  
  void set_color_background(const Gdk::Color& color);
  
  void feed(const std::string& data);
  
  void set_background_transparent(bool transparent = true);
  
  operator Gtk::Widget& () { return *Glib::wrap((GtkWidget*)m_gobj); }
  
private:
  
  VteTerminal* m_gobj;
  
};


#endif
