/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#include <cstdio>
#include <cstdlib>
#include <iostream>
#include <string>
#include <unistd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>

#include <glibmm/date.h>

#include "termwin.hpp"


using namespace Gtk;
using namespace sigc;
using namespace std;


TermWin::TermWin(LASHWrapper& lashd) : m_lashd(lashd) {
  set_title("LASH");
  Notebook* notebook = manage(new Notebook);
  notebook->append_page(m_term, "Server messages");
  add(*notebook);
  notebook->show_all();
}


void TermWin::toggle_visibility() {
  if (is_visible())
    hide();
  else
    show_all();
}


void TermWin::print_msg(const std::string& msg) {
  char tmp[12];
  time_t t = time(0);
  tm* ltime = localtime(&t);
  sprintf(tmp, "[%02d:%02d:%02d] ", 
          ltime->tm_hour, ltime->tm_min, ltime->tm_sec);
  m_term.feed("\033[34;1m");
  m_term.feed(tmp);
  m_term.feed("\033[0m");
  m_term.feed(msg + "\n\r");
}
