/****************************************************************************
   GLASHCtl - a simple tray applet for controlling lashd
   
   Copyright (C) 2006  Lars Luthman <lars.luthman@gmail.com>
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
****************************************************************************/

#ifndef TRAYICON_HPP
#define TRAYICON_HPP

#include <string>

#include <gtkmm/eventbox.h>
#include <gtkmm/iconset.h>
#include <gtkmm/image.h>
#include <gtkmm/menu.h>
#include <gtkmm/filechooserdialog.h>


class TrayIcon : public Gtk::EventBox {
public:

  TrayIcon();
  
  bool on_button_press_event(GdkEventButton* event);
  
  void lashd_started();
  void lashd_stopped();
  void session_changed(const std::string& name);
  
  sigc::signal<void> signal_start_lashd;
  sigc::signal<void> signal_stop_lashd;
  sigc::signal<void> signal_save_session;
  sigc::signal<void, const std::string&> signal_set_session_dir;
  sigc::signal<void, const std::string&> signal_set_session_name;
  sigc::signal<void> signal_close_session;
  sigc::signal<void, const std::string&> signal_restore_session;
  sigc::signal<void> signal_toggle_window;
  
private:
  
  void do_restore();
  void do_quit();
  void do_set_session_name();
  void do_set_session_dir();

  std::string m_session_name;
  
  Glib::RefPtr<Gdk::Pixbuf> m_pixbuf;
  Gtk::IconSet m_iconset;
  Gtk::Image m_image;
  Gtk::Menu m_menu;
  Gtk::MenuItem m_startitem;
  Gtk::MenuItem m_stopitem;
  Gtk::MenuItem m_restoreitem;
  Gtk::MenuItem m_saveitem;
  Gtk::MenuItem m_closeitem;
  Gtk::MenuItem m_setsessiondiritem;
  Gtk::MenuItem m_setsessionnameitem;
  Gtk::FileChooserDialog m_session_dialog;
  Gtk::FileChooserDialog m_session_save_dialog;
  
  bool m_lashd_running;
  
  sigc::signal<void> internal_signal_lashd_stopped;
};


#endif
