/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_CHEEKS_H
#define DOODLEHASH_CHEEKS_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>
G_BEGIN_DECLS
typedef struct
{
  DoodleHashObject * base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
}DoodleHashCheek;

struct _DoodleHashCheekPair
{
  DoodleHashCheek *left;
  DoodleHashCheek *right;
};

DoodleHashCheekPair* doodlehash_cheeks_new();
DoodleHashCheekPair* doodlehash_cheeks_copy(const DoodleHashCheekPair *orig);
DoodleHashCheekPair* doodlehash_cheeks_load_from_svg_file(const gchar *left, const gchar *right);
void doodlehash_cheeks_get_width_and_height(DoodleHashCheekPair* cheek, guint side, guint32* width, guint32* height);
guint32 doodlehash_cheeks_get_width(DoodleHashCheekPair* cheek, guint side);
guint32 doodlehash_cheeks_get_height(DoodleHashCheekPair* cheek, guint side);
void doodlehash_cheeks_set_width(DoodleHashCheekPair* cheek, guint side, guint32 width);
void doodlehash_cheeks_set_height(DoodleHashCheekPair* cheek, guint side, guint32 height);
void doodlehash_cheeks_get_head_connection_point(DoodleHashCheekPair* cheek, guint side, guint32* x, guint32* y);
guint32 doodlehash_cheeks_get_head_connection_point_x(DoodleHashCheekPair* cheek, guint side);
guint32 doodlehash_cheeks_get_head_connection_point_y(DoodleHashCheekPair* cheek, guint side);
void doodlehash_cheeks_set_head_connection_point(DoodleHashCheekPair* cheek, guint side, guint32 x, guint32 y);
void doodlehash_cheeks_set_random_matching_colours(DoodleHashCheekPair* cheek);
void doodlehash_cheeks_set_random_colours(DoodleHashCheekPair* cheek, guint code);
void doodlehash_cheeks_set_colours(DoodleHashCheekPair* cheek, guint side, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_cheeks_get_fill_colour(DoodleHashCheekPair* cheek, guint side, guint code);
gchar *doodlehash_cheeks_get_stroke_colour(DoodleHashCheekPair* cheek, guint side, guint code);
void doodlehash_cheeks_scale(DoodleHashCheekPair *cheek, guint side, double scale);
void doodlehash_cheeks_free(DoodleHashCheekPair* cheek);

G_END_DECLS
#endif /* DOODLEHASH_CHEEKS_H */
