/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_CHIN_H
#define DOODLEHASH_CHIN_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashChin
{
  DoodleHashObject *base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
};
DoodleHashChin* doodlehash_chin_new();
DoodleHashChin* doodlehash_chin_copy(const DoodleHashChin*orig);
DoodleHashChin* doodlehash_chin_load_from_svg_file(const char *file);
void doodlehash_chin_get_width_and_height(DoodleHashChin* chin, guint32* width, guint32* height);
guint32 doodlehash_chin_get_width(DoodleHashChin* chin);
guint32 doodlehash_chin_get_height(DoodleHashChin* chin);
void doodlehash_chin_set_width(DoodleHashChin* chin, guint32 width);
void doodlehash_chin_set_height(DoodleHashChin* chin, guint32 height);
void doodlehash_chin_get_head_connection_point(DoodleHashChin* chin, guint32* x, guint32* y);
guint32 doodlehash_chin_get_head_connection_point_x(DoodleHashChin* chin);
guint32 doodlehash_chin_get_head_connection_point_y(DoodleHashChin* chin);
void doodlehash_chin_set_head_connection_point(DoodleHashChin* chin, guint32 x, guint32 y);
void doodlehash_chin_set_random_colours(DoodleHashChin* chin, guint code);
void doodlehash_chin_set_colours(DoodleHashChin* chin, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_chin_get_fill_colour(DoodleHashChin* chin, guint code);
gchar *doodlehash_chin_get_stroke_colour(DoodleHashChin* chin, guint code);
void doodlehash_chin_scale(DoodleHashChin *chin, double scale);
void doodlehash_chin_free(DoodleHashChin* chin);

G_END_DECLS
#endif /* DOODLEHASH_CHIN_H */
