#include <libxml/tree.h>
#include <libxml/xmlwriter.h>
#include <string.h>
#include "loader.h"
#include "util.h"
#include "object.h"
#include "cheeks.h"
#include "chin.h"
#include "ears.h"
#include "earrings.h"
#include "eyebrows.h"
#include "eyes.h"
#include "hair.h"
#include "head.h"
#include "moustache.h"
#include "mouth.h"
#include "nose.h"
#include "spectacles.h"
#include "face.h"
DoodleHashObject* doodlehash_object_load_from_file(xmlNodePtr root);
void doodlehash_object_save_to_file(DoodleHashObject *object, xmlTextWriterPtr writer);
DoodleHashFace* doodlehash_face_load_from_file(xmlNodePtr root);
void doodlehash_face_save_to_file(DoodleHashFace *face, xmlTextWriterPtr writer);
DoodleHashCheekPair* doodlehash_cheeks_load_from_file(xmlNodePtr root);
void doodlehash_cheeks_save_to_file(DoodleHashCheekPair *cheeks, xmlTextWriterPtr writer);
DoodleHashChin* doodlehash_chin_load_from_file(xmlNodePtr root);
void doodlehash_chin_save_to_file(DoodleHashChin *chin, xmlTextWriterPtr writer);
DoodleHashEyeBrowPair* doodlehash_eyebrows_load_from_file(xmlNodePtr root);
void doodlehash_eyebrows_save_to_file(DoodleHashEyeBrowPair *eyebrows, xmlTextWriterPtr writer);
DoodleHashEyes* doodlehash_eyes_load_from_file(xmlNodePtr root);
void doodlehash_eyes_save_to_file(DoodleHashEyes *eyes, xmlTextWriterPtr writer);
DoodleHashEarRingPair* doodlehash_earrings_load_from_file(xmlNodePtr root);
void doodlehash_earrings_save_to_file(DoodleHashEarRingPair *earrings, xmlTextWriterPtr writer);
DoodleHashEarPair* doodlehash_ears_load_from_file(xmlNodePtr root);
void doodlehash_ears_save_to_file(DoodleHashEarPair *ears, xmlTextWriterPtr writer);
DoodleHashHair* doodlehash_hair_load_from_file(xmlNodePtr root);
void doodlehash_hair_save_to_file(DoodleHashHair *hair, xmlTextWriterPtr writer);
DoodleHashHead* doodlehash_head_load_from_file(xmlNodePtr root);
void doodlehash_head_save_to_file(DoodleHashHead *head, xmlTextWriterPtr writer);
DoodleHashMoustache* doodlehash_moustache_load_from_file(xmlNodePtr root);
void doodlehash_moustache_save_to_file(DoodleHashMoustache *moustache, xmlTextWriterPtr writer);
DoodleHashMouth* doodlehash_mouth_load_from_file(xmlNodePtr root);
void doodlehash_mouth_save_to_file(DoodleHashMouth *mouth, xmlTextWriterPtr writer);
DoodleHashNose* doodlehash_nose_load_from_file(xmlNodePtr root);
void doodlehash_nose_save_to_file(DoodleHashNose *nose, xmlTextWriterPtr writer);
DoodleHashSpectacles* doodlehash_spectacles_load_from_file(xmlNodePtr root);
void doodlehash_spectacles_save_to_file(DoodleHashSpectacles *spectacles, xmlTextWriterPtr writer);

G_END_DECLS
DoodleHashObject* doodlehash_object_load_from_file(xmlNodePtr root)
{
  DoodleHashObject *object = doodlehash_object_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "width") == 0)
        object->width = atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "height") == 0)
        object->height = atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "primary-stroke-colour") == 0)
        object->primary_stroke_colour = g_strdup((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "primary-fill-colour") == 0)
        object->primary_fill_colour = g_strdup((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "secondary-stroke-colour") == 0)
        object->secondary_stroke_colour = g_strdup((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "secondary-fill-colour") == 0)
        object->secondary_fill_colour = g_strdup((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "data") == 0)
        {
          object->data = g_strdup((char*) xmlNodeGetContent(child));
          object->data_len = strlen (object->data);
          get_colours((const guint8*)object->data, object->data_len, 
                      &object->primary_stroke_colours, 
                      &object->primary_fill_colours, 
                      &object->secondary_stroke_colours, 
                      &object->secondary_fill_colours, 
                      &object->num_colours);
        }
      child = child->next;
    }
  return object;
}


void doodlehash_object_save_to_file(DoodleHashObject *object, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*) "base");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", object->width);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"width", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", object->height);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"height", BAD_CAST buf);
  if (object->primary_stroke_colour)
    xmlTextWriterWriteElement(writer, (const xmlChar *)"primary-stroke-colour", BAD_CAST object->primary_stroke_colour);
  if (object->primary_fill_colour)
    xmlTextWriterWriteElement(writer, (const xmlChar *)"primary-fill-colour", BAD_CAST object->primary_fill_colour);
  if (object->secondary_stroke_colour)
    xmlTextWriterWriteElement(writer, (const xmlChar *)"secondary-stroke-colour", BAD_CAST object->secondary_stroke_colour);
  if (object->secondary_fill_colour)
    xmlTextWriterWriteElement(writer, (const xmlChar *)"secondary-fill-colour", BAD_CAST object->secondary_fill_colour);
  if (object->data)
    xmlTextWriterWriteElement(writer, (const xmlChar *)"data", BAD_CAST object->data);
  xmlTextWriterEndElement (writer);
}

void doodlehash_cheek_load_from_file(xmlNodePtr root, DoodleHashCheek *cheek)
{
  xmlNodePtr child = findNode(root, "cheek");
  if (!child)
    return;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        cheek->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        cheek->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        cheek->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return;
}

void doodlehash_cheek_save_to_file(DoodleHashCheek *cheek, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"cheek");
  doodlehash_object_save_to_file(cheek->base, writer);
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", cheek->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", cheek->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  xmlTextWriterEndElement (writer);
}

DoodleHashCheekPair* doodlehash_cheeks_load_from_file(xmlNodePtr root)
{
  xmlNodePtr child = root->xmlChildrenNode;
  DoodleHashCheekPair *cheeks = doodlehash_cheeks_new();
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "left") == 0)
        doodlehash_cheek_load_from_file (child, cheeks->left);
      else if (xmlStrcasecmp(child->name, BAD_CAST "right") == 0)
        doodlehash_cheek_load_from_file (child, cheeks->right);
      child = child->next;
    }
  return cheeks;
}

void doodlehash_cheeks_save_to_file(DoodleHashCheekPair *cheeks, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"cheeks");
  if (cheeks->left)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"left");
      doodlehash_cheek_save_to_file(cheeks->left, writer);
      xmlTextWriterEndElement (writer);
    }
  if (cheeks->right)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"right");
      doodlehash_cheek_save_to_file(cheeks->right, writer);
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterEndElement (writer);
}


DoodleHashChin* doodlehash_chin_load_from_file(xmlNodePtr root)
{
  DoodleHashChin *chin = doodlehash_chin_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        chin->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        chin->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        chin->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return chin;
}

void doodlehash_chin_save_to_file(DoodleHashChin *chin, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"chin");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", chin->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", chin->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  doodlehash_object_save_to_file(chin->base, writer);
  xmlTextWriterEndElement (writer);
}


void doodlehash_earring_load_from_file(xmlNodePtr root, DoodleHashEarRing *earring)
{
  xmlNodePtr child = findNode(root, "earring");
  if (!child)
    return;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-ear-x") == 0)
        earring->connect_to_ear_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-ear-y") == 0)
        earring->connect_to_ear_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        earring->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return;
}

void doodlehash_earring_save_to_file(DoodleHashEarRing *earring, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"earring");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", earring->connect_to_ear_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-ear-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", earring->connect_to_ear_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-ear-y", BAD_CAST buf);
  doodlehash_object_save_to_file(earring->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashEarRingPair* doodlehash_earrings_load_from_file(xmlNodePtr root)
{
  xmlNodePtr child = root->xmlChildrenNode;
  DoodleHashEarRingPair *earrings = doodlehash_earrings_new();
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "left") == 0)
        doodlehash_earring_load_from_file (child, earrings->left);
      else if (xmlStrcasecmp(child->name, BAD_CAST "right") == 0)
        doodlehash_earring_load_from_file (child, earrings->right);
      child = child->next;
    }
  return earrings;
}

void doodlehash_earrings_save_to_file(DoodleHashEarRingPair *earrings, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"earrings");
  if (earrings->left)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"left");
      doodlehash_earring_save_to_file(earrings->left, writer);
      xmlTextWriterEndElement (writer);
    }
  if (earrings->right)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"right");
      doodlehash_earring_save_to_file(earrings->right, writer);
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterEndElement (writer);
}

void doodlehash_ear_load_from_file(xmlNodePtr root, DoodleHashEar *ear)
{
  xmlNodePtr child = findNode(root, "ear");
  if (!child)
    return;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        ear->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        ear->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-earring-x") == 0)
        ear->connect_to_earring_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-earring-y") == 0)
        ear->connect_to_earring_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        ear->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return;
}

void doodlehash_ear_save_to_file(DoodleHashEar *ear, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"ear");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", ear->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", ear->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", ear->connect_to_earring_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-earring-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", ear->connect_to_earring_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-earring-y", BAD_CAST buf);
  doodlehash_object_save_to_file(ear->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashEarPair* doodlehash_ears_load_from_file(xmlNodePtr root)
{
  xmlNodePtr child = root->xmlChildrenNode;
  DoodleHashEarPair *ears = doodlehash_ears_new();
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "left") == 0)
        doodlehash_ear_load_from_file (child, ears->left);
      else if (xmlStrcasecmp(child->name, BAD_CAST "right") == 0)
        doodlehash_ear_load_from_file (child, ears->right);
      child = child->next;
    }
  return ears;
}

void doodlehash_ears_save_to_file(DoodleHashEarPair *ears, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"ears");
  if (ears->left)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"left");
      doodlehash_ear_save_to_file(ears->left, writer);
      xmlTextWriterEndElement (writer);
    }
  if (ears->right)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"right");
      doodlehash_ear_save_to_file(ears->right, writer);
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterEndElement (writer);
}



void doodlehash_eyebrow_load_from_file(xmlNodePtr root, DoodleHashEyeBrow *eyebrow)
{
  xmlNodePtr child = findNode(root, "eyebrow");
  if (!child)
    return;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-eye-x") == 0)
        eyebrow->connect_to_eye_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-eye-y") == 0)
        eyebrow->connect_to_eye_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        eyebrow->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return;
}

void doodlehash_eyebrow_save_to_file(DoodleHashEyeBrow *eyebrow, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"eyebrow");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", eyebrow->connect_to_eye_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-eye-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyebrow->connect_to_eye_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-eye-y", BAD_CAST buf);
  doodlehash_object_save_to_file(eyebrow->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashEyeBrowPair* doodlehash_eyebrows_load_from_file(xmlNodePtr root)
{
  xmlNodePtr child = root->xmlChildrenNode;
  DoodleHashEyeBrowPair *eyebrows = doodlehash_eyebrows_new();
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "left") == 0)
        doodlehash_eyebrow_load_from_file (child, eyebrows->left);
      else if (xmlStrcasecmp(child->name, BAD_CAST "right") == 0)
        doodlehash_eyebrow_load_from_file (child, eyebrows->right);
      child = child->next;
    }
  return eyebrows;
}

void doodlehash_eyebrows_save_to_file(DoodleHashEyeBrowPair *eyebrows, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"eyebrows");
  if (eyebrows->left)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"left");
      doodlehash_eyebrow_save_to_file(eyebrows->left, writer);
      xmlTextWriterEndElement (writer);
    }
  if (eyebrows->right)
    {
      xmlTextWriterStartElement (writer, (const xmlChar*)"right");
      doodlehash_eyebrow_save_to_file(eyebrows->right, writer);
      xmlTextWriterEndElement (writer);
    }
  xmlTextWriterEndElement (writer);
}


DoodleHashEyes* doodlehash_eyes_load_from_file(xmlNodePtr root)
{
  DoodleHashEyes *eyes = doodlehash_eyes_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        eyes->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        eyes->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-brow-x") == 0)
        eyes->connect_to_left_brow_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-brow-y") == 0)
        eyes->connect_to_left_brow_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-brow-x") == 0)
        eyes->connect_to_right_brow_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-brow-y") == 0)
        eyes->connect_to_right_brow_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        eyes->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return eyes;
}

void doodlehash_eyes_save_to_file(DoodleHashEyes *eyes, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"eyes");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_left_brow_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-left-brow-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_left_brow_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-left-brow-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_right_brow_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-right-brow-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", eyes->connect_to_right_brow_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-right-brow-y", BAD_CAST buf);
  doodlehash_object_save_to_file(eyes->base, writer);
  xmlTextWriterEndElement (writer);
}


DoodleHashFace * doodlehash_face_load_from_file(xmlNodePtr root)
{
  DoodleHashFace *f = doodlehash_face_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "cheeks") == 0)
        f->cheeks = doodlehash_cheeks_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "chin") == 0)
        f->chin = doodlehash_chin_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "ears") == 0)
        f->ears = doodlehash_ears_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "earrings") == 0)
        f->earrings = doodlehash_earrings_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "eyebrows") == 0)
        f->eyebrows = doodlehash_eyebrows_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "eyes") == 0)
        f->eyes = doodlehash_eyes_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "hair") == 0)
        f->hair = doodlehash_hair_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "head") == 0)
        f->head = doodlehash_head_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "moustache") == 0)
        f->moustache = doodlehash_moustache_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "mouth") == 0)
        f->mouth = doodlehash_mouth_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "nose") == 0)
        f->nose = doodlehash_nose_load_from_file(child);
      else if (xmlStrcasecmp(child->name, BAD_CAST "spectacles") == 0)
        f->spectacles = doodlehash_spectacles_load_from_file(child);
      child = child->next;
    }
  return f;
}

void doodlehash_face_save_to_file(DoodleHashFace *f, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"face");
  if (f->cheeks)
    doodlehash_cheeks_save_to_file(f->cheeks, writer);
  if (f->chin)
    doodlehash_chin_save_to_file(f->chin, writer);
  if (f->ears)
    doodlehash_ears_save_to_file(f->ears, writer);
  if (f->earrings)
    doodlehash_earrings_save_to_file(f->earrings, writer);
  if (f->eyebrows)
    doodlehash_eyebrows_save_to_file(f->eyebrows, writer);
  if (f->eyes)
    doodlehash_eyes_save_to_file(f->eyes, writer);
  if (f->hair)
    doodlehash_hair_save_to_file(f->hair, writer);
  if (f->head)
    doodlehash_head_save_to_file(f->head, writer);
  if (f->moustache)
    doodlehash_moustache_save_to_file(f->moustache, writer);
  if (f->mouth)
    doodlehash_mouth_save_to_file(f->mouth, writer);
  if (f->nose)
    doodlehash_nose_save_to_file(f->nose, writer);
  if (f->spectacles)
    doodlehash_spectacles_save_to_file(f->spectacles, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashHair * doodlehash_hair_load_from_file(xmlNodePtr root)
{
  DoodleHashHair *s = doodlehash_hair_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        s->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return s;
}

void doodlehash_hair_save_to_file(DoodleHashHair *s, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"hair");
  doodlehash_object_save_to_file(s->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashHead* doodlehash_head_load_from_file(xmlNodePtr root)
{
  DoodleHashHead *head= doodlehash_head_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-chin-x") == 0)
        head->connect_to_chin_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-chin-y") == 0)
        head->connect_to_chin_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-nose-x") == 0)
        head->connect_to_nose_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-nose-y") == 0)
        head->connect_to_nose_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-mouth-x") == 0)
        head->connect_to_mouth_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-mouth-y") == 0)
        head->connect_to_mouth_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-eyes-x") == 0)
        head->connect_to_eyes_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-eyes-y") == 0)
        head->connect_to_eyes_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-ear-x") == 0)
        head->connect_to_left_ear_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-ear-y") == 0)
        head->connect_to_left_ear_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-ear-x") == 0)
        head->connect_to_right_ear_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-ear-y") == 0)
        head->connect_to_right_ear_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-cheek-x") == 0)
        head->connect_to_left_cheek_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-left-cheek-y") == 0)
        head->connect_to_left_cheek_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-cheek-x") == 0)
        head->connect_to_right_cheek_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-right-cheek-y") == 0)
        head->connect_to_right_cheek_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        head->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return head;
}

void doodlehash_head_save_to_file(DoodleHashHead *head, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"head");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", head->connect_to_chin_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-chin-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_chin_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-chin-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_nose_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-nose-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_nose_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-nose-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_mouth_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-mouth-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_mouth_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-mouth-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_eyes_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-eyes-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_eyes_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-eyes-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_left_ear_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-left-ear-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_left_ear_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-left-ear-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_right_ear_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-right-ear-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_right_ear_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-right-ear-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_left_cheek_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-left-cheek-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_left_cheek_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-left-cheek-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_right_cheek_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-right-cheek-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", head->connect_to_right_cheek_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-right-cheek-y", BAD_CAST buf);
  doodlehash_object_save_to_file(head->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashMoustache* doodlehash_moustache_load_from_file(xmlNodePtr root)
{
  DoodleHashMoustache *moustache = doodlehash_moustache_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-mouth-x") == 0)
        moustache->connect_to_mouth_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-mouth-y") == 0)
        moustache->connect_to_mouth_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        moustache->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return moustache;
}

void doodlehash_moustache_save_to_file(DoodleHashMoustache *moustache, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"moustache");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", moustache->connect_to_mouth_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-mouth-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", moustache->connect_to_mouth_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-mouth-y", BAD_CAST buf);
  doodlehash_object_save_to_file(moustache->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashMouth* doodlehash_mouth_load_from_file(xmlNodePtr root)
{
  DoodleHashMouth *mouth = doodlehash_mouth_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        mouth->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        mouth->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-moustache-x") == 0)
        mouth->connect_to_moustache_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-moustache-y") == 0)
        mouth->connect_to_moustache_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        mouth->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return mouth;
}

void doodlehash_mouth_save_to_file(DoodleHashMouth *mouth, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"mouth");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", mouth->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", mouth->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", mouth->connect_to_moustache_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-moustache-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", mouth->connect_to_moustache_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-moustache-y", BAD_CAST buf);
  doodlehash_object_save_to_file(mouth->base, writer);
  xmlTextWriterEndElement (writer);
}
DoodleHashNose* doodlehash_nose_load_from_file(xmlNodePtr root)
{
  DoodleHashNose *nose = doodlehash_nose_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-x") == 0)
        nose->connect_to_head_x= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "connect-to-head-y") == 0)
        nose->connect_to_head_y= atoi((char*) xmlNodeGetContent(child));
      else if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        nose->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return nose;
}

void doodlehash_nose_save_to_file(DoodleHashNose *nose, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"nose");
  char buf [32];
  snprintf(buf, sizeof(buf), "%u", nose->connect_to_head_x);
  xmlTextWriterWriteElement (writer, (const xmlChar *)"connect-to-head-x", BAD_CAST buf);
  snprintf(buf, sizeof(buf), "%u", nose->connect_to_head_y);
  xmlTextWriterWriteElement(writer, (const xmlChar *)"connect-to-head-y", BAD_CAST buf);
  doodlehash_object_save_to_file(nose->base, writer);
  xmlTextWriterEndElement (writer);
}
DoodleHashSpectacles * doodlehash_spectacles_load_from_file(xmlNodePtr root)
{
  DoodleHashSpectacles *s = doodlehash_spectacles_new();

  xmlNodePtr child = root->xmlChildrenNode;
  while (child) 
    {
      if (xmlStrcasecmp(child->name, BAD_CAST "base") == 0)
        s->base = doodlehash_object_load_from_file(child);
      child = child->next;
    }
  return s;
}

void doodlehash_spectacles_save_to_file(DoodleHashSpectacles *s, xmlTextWriterPtr writer)
{
  xmlTextWriterStartElement (writer, (const xmlChar*)"spectacles");
  doodlehash_object_save_to_file(s->base, writer);
  xmlTextWriterEndElement (writer);
}

DoodleHashFace *doodlehash_load_face(const char *file)
{
  xmlNodePtr root;
  xmlDocPtr doc = xmlParseFile(file);
  if (!doc)
    return NULL;
  root = xmlDocGetRootElement(doc);
  if (!root)
    return NULL;
  DoodleHashFace *f = doodlehash_face_load_from_file(root);
  xmlFreeDoc(doc);
  return f;
}

int doodlehash_save_face(DoodleHashFace *face, const char *file)
{
  xmlTextWriterPtr writer = xmlNewTextWriterFilename(file, 0);
  xmlTextWriterSetIndent (writer, 1);
  xmlTextWriterSetIndentString (writer, (const xmlChar*) "  ");
  xmlTextWriterStartDocument (writer, "1.0", NULL, NULL);
  doodlehash_face_save_to_file(face, writer);
  xmlTextWriterEndDocument (writer);
  xmlFreeTextWriter(writer);
  return 0;
}
