/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope tobject it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_OBJECT_H
#define DOODLEHASH_OBJECT_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashObject
{
  gchar *data;
  gsize data_len;
  guint32 height;
  guint32 width;
  char *primary_stroke_colour;
  char *primary_fill_colour;
  char *secondary_stroke_colour;
  char *secondary_fill_colour;
  gchar **primary_stroke_colours;
  gchar **primary_fill_colours;
  gchar **secondary_stroke_colours;
  gchar **secondary_fill_colours;
  guint32 num_colours;
};
DoodleHashObject* doodlehash_object_new();
DoodleHashObject *doodlehash_object_copy();
void doodlehash_object_set_random_colours(DoodleHashObject* object, guint colourcode);
void doodlehash_object_set_colours(DoodleHashObject* object, guint colourcode, char *stroke_colour, char *fill_colour);
gchar *doodlehash_object_get_fill_colour(DoodleHashObject* object, guint colourcode);
gchar *doodlehash_object_get_stroke_colour(DoodleHashObject* object, guint colourcode);
int doodlehash_object_load_from_svg_file(DoodleHashObject *o, const gchar *file);
int doodlehash_object_set_width_and_height_from_svg_file(DoodleHashObject *o, const char *file);
void doodlehash_object_get_width_and_height(DoodleHashObject* object, guint32* width, guint32* height);
guint32 doodlehash_object_get_width(DoodleHashObject* object);
guint32 doodlehash_object_get_height(DoodleHashObject* object);
void doodlehash_object_set_width(DoodleHashObject* object, guint32 width);
void doodlehash_object_set_height(DoodleHashObject* object, guint32 height);
void doodlehash_object_scale(DoodleHashObject *object, double scale);
int doodlehash_object_has_data(DoodleHashObject *object);
void doodlehash_object_free(DoodleHashObject* object);

//functions that operate on one or more object
void doodlehash_object_set_random_matching_colours(DoodleHashObject *first, ...);

//function that operate on files
guint32 doodlehash_object_get_width_from_svg_file(const char *file);

G_END_DECLS

#endif /* DOODLEHASH_OBJECT_H */
