/*  Copyright (C) 2011 Ben Asselstine
 *  This file originates in the doodlehash project.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
 *  02110-1301, USA.
 */
#ifndef DOODLEHASH_NOSE_H
#define DOODLEHASH_NOSE_H

#include <glib.h>
#include <libdoodlehash/doodlehash-types.h>
#include <libdoodlehash/doodlehash-enums.h>

G_BEGIN_DECLS
struct _DoodleHashNose
{
  DoodleHashObject *base;
  guint32 connect_to_head_x;
  guint32 connect_to_head_y;
};
DoodleHashNose* doodlehash_nose_new();
DoodleHashNose* doodlehash_nose_copy(const DoodleHashNose*orig);
DoodleHashNose* doodlehash_nose_load_from_svg_file(const char *file);
void doodlehash_nose_get_width_and_height(DoodleHashNose* nose, guint32* width, guint32* height);
guint32 doodlehash_nose_get_width(DoodleHashNose* nose);
guint32 doodlehash_nose_get_height(DoodleHashNose* nose);
void doodlehash_nose_set_width(DoodleHashNose* nose, guint32 width);
void doodlehash_nose_set_height(DoodleHashNose* nose, guint32 height);
void doodlehash_nose_get_head_connection_point(DoodleHashNose* nose, guint32* x, guint32* y);
guint32 doodlehash_nose_get_head_connection_point_x(DoodleHashNose* nose);
guint32 doodlehash_nose_get_head_connection_point_y(DoodleHashNose* nose);
void doodlehash_nose_set_head_connection_point(DoodleHashNose* nose, guint32 x, guint32 y);
void doodlehash_nose_set_random_colours(DoodleHashNose* nose, guint code);
void doodlehash_nose_set_colours(DoodleHashNose* nose, guint code, char *stroke_colour, char *fill_colour);
gchar *doodlehash_nose_get_fill_colour(DoodleHashNose* nose, guint code);
gchar *doodlehash_nose_get_stroke_colour(DoodleHashNose* nose, guint code);
void doodlehash_nose_scale(DoodleHashNose *n, double scale);
void doodlehash_nose_free(DoodleHashNose* nose);

G_END_DECLS
#endif /* DOODLEHASH_NOSE_H */
