#include <stdio.h>
#include <gtk/gtk.h>
#include <libdoodlehash/doodlehash.h>

int main(int argc, char **argv)
{
  int retval = 1;
  gtk_init(&argc, &argv);
  retval = doodlehash_init();
  if (retval != 0)
    return retval;

  unsigned int i = 0;
  for (i = 0; i < 1000; i++)
    {
      char buf[32];
      snprintf(buf, sizeof (buf), "%05u", i);
      GdkPixbuf *pixbuf = doodlehash_new_pixbuf(buf, 512, 512);
      gchar *png_file = g_strdup_printf("pic-%s%s", buf, ".png");
      gdk_pixbuf_save(pixbuf, png_file, "png", NULL, NULL);
      g_free(png_file);
      g_object_unref(pixbuf);
    }
  fprintf(stdout, "Now you can make a montage with the command: montage pic*.png faces.png\n");

  doodlehash_term();
  return retval;
}
