#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.
#allows selection of a map to load

from Tkinter import *
from os import listdir
import m

global my_map

global result
result = 0

#take the selected module from the listbox, and send to sel_mod
def sel_list_map():
	if (len(listbox_mods.curselection()) == 0): return 0
	try: mod_num = map(int, listbox_mods.curselection())
	except ValueError: pass
	map_name = listbox_mods.get(mod_num[0])
	sel_map(map_name)

#given a certain map, open it.
def sel_map(selected_map):
	global mapname
	mapname = selected_map
	map_loc = "../modules/Dragon Hunt/data/maps/" + selected_map
	map_file = open(map_loc, 'r')
	map_line = map_file.readline()
	global my_map
	my_map = m.map(mapname)
	while map_line != '' and map_line[:1] != ":":
	    #strip out leading and trailing whitespace
	    map_line = map_line.strip()

	    #ignore blank lines and comments
	    if map_line[:1] == "#" or map_line[:1] == "" or map_line[:1] == "\n":
		    map_line = map_file.readline()
		    continue

	    #add the line
	    line = map_line.split(" ")
	    my_map.field.append(line)

	    #read another line
	    map_line = map_file.readline()

	# get tile pix definitions and store in field_codes
	got_info = 0
	while map_line != '':
	    map_line = map_line.strip()

	    #allow the \ line-continuation character.
	    while map_line[-1:] == "\\":  #really a single backslash, BTW.
		    map_line = map_line[:-1] + map_file.readline()[:-1] #for \n

	    #is this line giving us a new tile?
	    if map_line[:1] == ":":
		    current_tile = map_line[1:]
		    tile_obj = m.tile(current_tile)
		    got_info = 1
		    map_line = map_file.readline()
		    continue

	    elif map_line[:3] == "pix":
		pixname = map_line[4:]
		tile_obj.pixname = pixname
		got_info = got_info + 1
		if(current_tile == 'a'):
		    my_map.border = pixname

	    elif map_line[:4] == "walk":
		tile_obj.walk = map_line[5:]
		got_info = got_info + 1

	    if got_info == 3:
		my_map.add_tile(current_tile, tile_obj)
		got_info = 0

	    #read another line
	    map_line = map_file.readline()

	map_file.close()
	#done
	global result
	result = 1
	window_sel_game.destroy()

def cancel():
	global result
	result = 0
	window_sel_game.destroy()

def quit():
    window_sel_game.destroy()

def init_window():
	global window_sel_game
	window_sel_game = Toplevel()

	array_mods = listdir("../modules/Dragon Hunt/data/maps/")
 	#remove CVS directory
        i = 0
        while i < len(array_mods):
		if array_mods[i] == "CVS":
			array_mods.pop(i)
		else:
			i += 1

	#if there is only one module, run it.
	if (len(array_mods) == 1):
		sel_map(array_mods[0])
		return 0

	window_sel_game.title("Select Map")
	window_sel_game.resizable(10, 10)
	window_sel_game.wm_geometry("+%d+%d" % (20, 20))

	global listbox_mods
	listbox_mods = Listbox(window_sel_game, height=10) #, takefocus=0)
	listbox_mods.grid(row=1, column=1, rowspan=10, sticky=N+W+E)

	global button_sel
	button_sel = Button(window_sel_game, text="Select Map",
		command=sel_list_map)
	button_sel.grid(row=1, column=0)

	global button_quit
	button_quit = Button(window_sel_game, text="Cancel", command=cancel)
	button_quit.grid(row=2, column=0)


	for modname in array_mods:
		listbox_mods.insert(END, modname)

	window_sel_game.master.wait_window(window_sel_game)
	return result
