#file: map_editor.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

# This file runs a map editing program.
# Currently, loading maps does not work.
# Author: Allison Marles
# Date: Sept.1, 2004

from Tkinter import *
#needed for the tiles.
import ImageTk
import Image
import re
from os import path, mkdir, remove, walk
import load_map
import m

import g
#for later; should be able to link these together to get more power.
#import scripting

mapsize =25
tilesize=32
bgcolour='lightgrey'
window = Toplevel()
window.title("Map Editor")


cur_tile = ""
cur_tile_num = 0
cur_x = 0
cur_y = 0
border = "rock.png"
background = "grass.png"
map_name = "map.txt"
tile_set_size = 0
tilebox_width = 4
tilegrid = 1

def create_map():
	global top
	try: top.destroy()
	except NameError: pass
	top = Frame(window,bd=2, relief=SUNKEN, bg=bgcolour);
	top.grid(row=1, column=1, columnspan=mapsize+1, sticky=E)

	#this creates the actual map portion.
	global label_map
	label_map = []
	global tile_map
	tile_map = []
	for x in range(mapsize):
		for y in range(mapsize):
			label_map.append(x*mapsize+y)
			tile_map.append(x*mapsize+y)
			if(x==0 or x==mapsize-1 or y==0 or y==mapsize-1):
			    set_tile(x, y, border)
			else:
			   set_tile(x, y, background)

#    for x in range(mapsize):
#	for y in range(mapsize):
#	    set_tile(x, y, tile)


#set all tiles to background tile
def set_bkg(bkg):
	global background
	background = bkg
	refresh_map(0)

#what will appear around edges of map (must be walk 0 to keep hero penned in)
def set_border(edge):
    global border
    border = edge
    refresh_map(1)

#redraw map with current border and background settings
def refresh_map(num):
   	for x in range(mapsize):
		for y in range(mapsize):
		        if(num==1):
			    if(x==0 or x==mapsize-1 or y==0 or y==mapsize-1):
			       set_tile(x, y, border)
			elif(num == 0):
			    if(x!=0 and x!=mapsize-1 and y!=0 and y!=mapsize-1):
				set_tile(x, y, background)

def set_tile_callback(x, y):
    if(cur_tile != ""):
       set_tile(x, y, cur_tile)

#set tile at x, y to name and add callback so when clicked on, tile gets set to cur_tile
def set_tile(x, y, name):
	try: label_map[x*mapsize+y].destroy()
	except AttributeError: pass
	label_map[x*mapsize+y] = Label(top, image=tiles[name], borderwidth=tilegrid)
	label_map[x*mapsize+y].grid(column = y, row=x)
	label_map[x*mapsize+y].bind("<Button-1>", lambda event, a=x, b=y:set_tile_callback(a, b))
	tile_map[x*mapsize+y] = name

#this loads the various tiles.
def load_tiles():
	global tiles
	tiles = {"blank" : ImageTk.PhotoImage("RGB", (tilesize, tilesize))}
	global tilenames
	tilenames= []
	global num_tiles
	num_tiles = 0

	for root, dirs, files in walk(g.mod_directory + "/images/tiles/"):
		(head, tail) = path.split(root)
		if (tail != "CVS"):
			for tilename in files:
			    num_tiles = num_tiles + 1
			    #if image is in a sub-dir:
			    if (root != g.mod_directory + "/images/tiles/"):
				i = len(g.mod_directory + "/images/tiles/")
				tilenames.append(root[i:] + "/" + tilename)
				tiles[root[i:] + "/" + tilename] = \
				    ImageTk.PhotoImage(file=root + "/" + tilename)
			    else: #if image is in root dir
				tilenames.append(tilename)
				tiles[tilename] = \
				    ImageTk.PhotoImage(file=root + "/" + tilename)
	get_walk_values()

def get_walk_values():
    global walk
    walk = {"blank" : StringVar}
    walk_defs_loc = g.mod_directory + "/data/" + "walk_defs.txt"
    walk_defs = open(walk_defs_loc, 'r')
    #read lines, store in walk[tilename] = 1 or 0
    walk_line = walk_defs.readline()
    while walk_line != '' and walk_line[:1] != ":":
	 #strip out leading and trailing whitespace
	 walk_line = walk_line.strip()

	 #ignore blank lines and comments
	 if walk_line[:1] == "#" or walk_line[:1] == "" or walk_line[:1] == "\n":
		 walk_line = walk_defs.readline()
		 continue

	 #add the line
	 line = walk_line.split(" ")
	 walk[line[0]] = line[1]

	 #ready another line
	 walk_line = walk_defs.readline()



# create array code_def of tilenames mapping to map codes
# do this when saving so that border is up to date
def set_codes():
    global code_def
    code_def = {"blank" : StringVar}
    codes = []
    count = 0
    for i in  "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789":
	codes.append(count)
	codes[count] = i
	count = count + 1
	for j in "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789":
	   codes.append(count)
	   codes[count] = i + j
	   count = count + 1
    code_def[border] = codes[0]
    cur = 1
    for tile in tilenames:
	if (tile != border):
	   code_def[tile] = codes[cur]
	   cur = cur + 1

#set current tile to work with
def choose_tile(file, num):
    global cur_tile
    global cur_tile_num
    cur_tile = file
    cur_tile_num = num
    refresh_tiles()

#set up tile
def setup_tilebox():
    global bottom
    bottom = Frame(window,bd=2, relief=SUNKEN, bg="lightgreen");
    bottom.grid(row=1, column=mapsize+2, columnspan=num_tiles/mapsize, sticky=E)
    #this creates the tile display portion
    global tilebox
    tilebox = []

# show tile set as buttons
def display_tiles(set = "default"):
	global bottom
	bottom.destroy()
	bottom = Frame(window,bd=2, relief=SUNKEN, bg="lightgreen");
	bottom.grid(row=1, column=mapsize+2, columnspan=tilebox_width, sticky=NE)
	cur_row = 1
	col_start = mapsize+1
	col_span = tilebox_width
	cur_col = col_start
	cur = 0
	global tile_set_size
	tile_set_size = 0

	for file in tilenames:
		file_prefix = file.split("/", 1)[0]
		end_in_png = file_prefix[len(file_prefix)-4:len(file_prefix)]
		#if not in a sub-dir, then this tile is in default set
		if(end_in_png == ".png"):
		    file_prefix = "default"

		#only show tiles in appropriate set (ie. correct subdir)
		if(file_prefix == set):
		    tile_set_size = tile_set_size + 1
		    if cur_col == col_start + col_span:
			cur_row = cur_row + 1
			cur_col = col_start
		    tilebox.append(cur)
		    tilebox[cur] = Button(bottom, image=tiles[file], borderwidth=1,
				    bg="black", activebackground = "red",
				    command=(lambda x=file, y=cur:choose_tile(x, y)))
		    tilebox[cur].grid(column=cur_col, row=cur_row)
		    cur_col = cur_col + 1
		    cur = cur + 1

def refresh_tiles():
	for cur in range(tile_set_size):
		tile_button = tilebox[cur]
		if(cur != cur_tile_num):
		   tile_button.config(bg="black")
		else:
		   tile_button.config(bg="red")

def quit_command(event=0):
    try:
	window.destroy()
	raise SystemExit
    except TclError:
	pass

#save map to map dir and call it map.txt
def save_map(event=0):
    set_codes()
    map_loc = g.mod_directory + "/data/maps/" + "map.txt"
    print "Saving map to " + map_loc
    map_file = open(map_loc, 'w')
    for x in range(mapsize):
	for y in range(mapsize):
	    map_file.write(code_def[tile_map[x*mapsize+y]]+ " ")
	map_file.write("\n")
    map_file.write("\n:def\n")
    for tile in tilenames:
	for x in range(mapsize): #check if the tile was actually used.
		for y in range(mapsize):
			if code_def[tile_map[x*mapsize+y]] == code_def[tile]:
				break
		else: continue #bit confusing here; this breaks out of both loops
		break          #if the tile was found, and actually saves it.
	else: continue  #The tile wasn't used. Try the next one.
	map_file.write(":" + code_def[tile] + "\n")
	tile_prefix = tile.split("/", 1)
	if(tile_prefix[0] == "items"):
	     replace_pix = tile_prefix[1].split("_", 1)[0]
	     thing = tile_prefix[1]
	     thing = thing[0:len(thing)-4]
	     foo = replace_pix + "_"
	     name_of_item = re.sub(foo, "", thing)
	     item_name = re.sub("_", " ", name_of_item)
	     map_file.write("if var pickedup_" + tile_prefix[1] + "|pix items/" + replace_pix + ".png|pix " + tile + "\n")
	     map_file.write("walk " + walk[tile] + "\n")
	     map_file.write("Action\nif var pickedup_" + tile_prefix[1] + "| end |find \"" + item_name + "\" AMOUNT\n")
	     map_file.write("if got \"" + item_name + "\" | set pickedup_" + tile_prefix[1] + " = 1|end\n")
	     map_file.write("pix items/" + replace_pix + ".png\n")
	else:
	    map_file.write("pix " + tile + "\n")
	    map_file.write("walk " + walk[tile] + "\n")

    map_file.close()

def display_loaded_map():
    x = 0
    y = 0
    set_border(load_map.my_map.border)
    set_bkg(load_map.my_map.background)
    for row in load_map.my_map.field:
	for col in row:
	    cur_pix =  load_map.my_map.tiles[col].pixname
	    set_tile(y, x, cur_pix)
	    x = x + 1
	y = y + 1
	x = 0

def do_load_map():
    if (load_map.init_window() == 0): return
    map_name = load_map.my_map.mapname
    display_loaded_map()

def change_mapsize(size):
	global mapsize
	mapsize = size
	create_map()
	refresh_map(1)

def toggle_grid():
	global tilegrid
	if tilegrid == 0: tilegrid = 1
	elif tilegrid == 1: tilegrid = 0
	for x in range(mapsize):
		for y in range(mapsize):
			label_map[x*mapsize+y].config(borderwidth=tilegrid)

def make_menus():
    global menubar
    menubar = Frame(window, bg=bgcolour)
    menubar.grid(row=0, column=1, sticky=W)
    #main menu
    mbutton = Menubutton(menubar, text='Main Menu', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    picks.add_command(label='Load Map', command=do_load_map)
    picks.add_command(label='Save', command=save_map)
    picks.add_command(label='Quit', command=quit_command)
    mbutton.grid(row=0, column=1, sticky=NW)
    #background menu
    mbutton = Menubutton(menubar, text='Set Background', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    picks.add_command(label='water', command=(lambda x="water/water.png":set_bkg(x)))
    picks.add_command(label='dirt', command=(lambda x="underground/dirt.png":set_bkg(x)))
    picks.add_command(label='void', command=(lambda x="underground/void.png":set_bkg(x)))
    picks.add_command(label='grass', command=(lambda x="grass.png":set_bkg(x)))
    mbutton.grid(row=0, column=2, sticky=NW)
    #border menu
    mbutton = Menubutton(menubar, text='Set Border', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    picks.add_command(label='water', command=(lambda x="water/water.png":set_border(x)))
    picks.add_command(label='rock', command=(lambda x="rock.png":set_border(x)))
    picks.add_command(label='hills', command=(lambda x="hills/hills_n4.png":set_border(x)))
    picks.add_command(label='cave', command=(lambda x="underground/rock.png":set_border(x)))
    picks.add_command(label='void', command=(lambda x="underground/void.png":set_border(x)))
    mbutton.grid(row=0, column=3, sticky=NW)
    #tile set menu
    mbutton = Menubutton(menubar, text='Tile Set', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    for root, dirs, files in walk(g.mod_directory + "/images/tiles/"):
	(head, tail) = path.split(root)
	if (tail != "CVS"):
	    if(tail == ""):
		picks.add_command(label="default", command=(lambda x="default":display_tiles(x)))
	    else:
		picks.add_command(label=tail, command=(lambda x=tail:display_tiles(x)))
    mbutton.grid(row=0, column=4, sticky=NW)
	#mapsize menu
    mbutton = Menubutton(menubar, text='Set Map size', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    picks.add_command(label='10x10', command=(lambda x=10:change_mapsize(x)))
    picks.add_command(label='15x15', command=(lambda x=15:change_mapsize(x)))
    picks.add_command(label='20x20', command=(lambda x=20:change_mapsize(x)))
    picks.add_command(label='25x25', command=(lambda x=25:change_mapsize(x)))
    mbutton.grid(row=0, column=5, sticky=NW)
	#display menu
    mbutton = Menubutton(menubar, text='Display', bg=bgcolour)
    picks = Menu(mbutton, bg=bgcolour)
    mbutton.config(menu=picks)
    picks.add_command(label='Toggle Grid', command=(lambda x=1:toggle_grid()))
    mbutton.grid(row=0, column=6, sticky=NW)

    window.bind("<Escape>", quit_command)
    window.bind("q", quit_command)

from os import listdir
array_mods = listdir("../modules/")
i = 0
while i < len(array_mods):
       if array_mods[i] == "CVS":
	       array_mods.pop(i)
       else:
	       i += 1
g.mod_directory = "../modules/" + array_mods[0]
make_menus()
load_tiles()
create_map()
setup_tilebox()
display_tiles("default")
window.master.withdraw()
window.master.wait_window(window)
