#battle.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#this file controls the window_battle window.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image
import os.path #for checking on existance of monster pixs.

import g
import main
import action

mon_index = 0

mon_hp = StringVar()
hp = StringVar()
ep = StringVar()

help_text = StringVar()

#location of the various buttons. (Pixels from the left of the button canvas)
attack_button_loc = 0
item_button_loc = 0
skill_button_loc = 0
run_button_loc = 0



#did you run from this battle? Used for scripting.
did_run = 0

#currently selected button. 0=attack, 1=run/leave, 2=use item, 3=use skill
cur_button = 0


#refreshes the battle view. Call after changing anything.
def refresh():
	mon_hp.set(str(g.cur_mon_hp) + "/" + str(g.monster[mon_index][1]))

	#hp/ep bars
	canvas_mon_hp.delete("show_mon_hp")
	temp_width = g.hpbar_width*g.cur_mon_hp/g.monster[mon_index][1]
	if temp_width < 0: temp_width=0
	canvas_mon_hp.create_rectangle(0, 0, temp_width,
		g.hpbar_width/6, fill="#05BB05", tags="show_mon_hp")

	main.recalc_stats()

	#clear and rebuild listbox_item
	listbox_item.delete(0, END)
	for i in g.inv:
		if i != -1 and (g.item[i][1] == 11 or g.item[i][1] == 12):
			listbox_item.insert(END, g.item[i][0])

	#clear and rebuild listbox_skill
	listbox_skill.delete(0, END)
	for i in range(len(g.skill)):
		if g.skill[i][5] == 1 and g.skill[i][2] <= g.ep:
			listbox_skill.insert(END, g.skill[i][0] + ": "
				+ str(g.skill[i][2]) + " EP")


#attack button was pressed
def attack(event=0):
	global cur_button
	if g.cur_mon_hp > 0 and g.hp > 0:
		attack_monster()
	if g.cur_mon_hp > 0 and g.hp > 0:
		attack_player()
		refresh()
		refresh_buttons()

#attack the monster
def attack_monster():
	global cur_mon_hp
	#find the damage done
	damage = g.die_roll(1, g.adj_attack + 2)
	damage = damage - g.die_roll(1, g.monster[mon_index][3] + 2)
	if damage > 0:
 		main.print_message("You hit the " + g.monster[mon_index][0] +
 			" for " + str(damage) + " damage.")
		g.cur_mon_hp = g.cur_mon_hp - damage
		#you kill it?
		if g.cur_mon_hp <= 0:
			monster_dead()
			return 0
	else:
		main.print_message("You miss the " + g.monster[mon_index][0] + ".")


#monster attacks you
def attack_player():
	damage = g.die_roll(1, g.monster[mon_index][2] + 2)
	damage = damage - g.die_roll(1, g.adj_defense + 2)
	if damage > 0:
		main.print_message("The " + g.monster[mon_index][0] +
		" hits you for " + str(damage) + " damage.")
		g.hp = g.hp - damage
		#you dead yet?
		if g.hp <= 0:
			main.print_message("The " + g.monster[mon_index][0] +
			" kills you.")
			cur_button = 1

	elif g.cur_mon_hp > 0:
		main.print_message("The " + g.monster[mon_index][0] +
		" misses you.")
	refresh()

#use to reward the player for killing a monster
def monster_dead():
	global cur_mon_hp
	#make the display look better
	g.cur_mon_hp = 0
	#add info to listbox_move; add gold and xp
	main.print_message("The " + g.monster[mon_index][0] +
	" dies.")
	gold = g.monster[mon_index][5]
	g.gold = str(int(g.gold) + gold)
	main.print_message("You find " + str(gold) + " gold,")

	exp = g.monster[mon_index][4]
	g.exp = int(g.exp) + exp
	main.print_message("and get " + str(exp) + " experience.")

	#gain a level?
	if int(g.exp) >= int(10*(g.level + 1)*(g.level + 1)):
		g.level=g.level+1
		main.print_message("You gain a level.")
		for i in g.levelup_act:
			action.activate_line(g.xgrid, g.ygrid, g.zgrid, i)

	#formatting
	#refresh()
	window_battle.destroy()
	global did_run
	did_run = 0

#run/leave/quit button was pressed
def runaway():
	try:
		#if window_battle.state() != "normal":
		#	return
		#leave/quit
		if g.hp <= 0 or g.cur_mon_hp <= 0:
			window_battle.destroy()
		#run
		else:
			if g.die_roll(1, 10) > 7:
				window_battle.destroy()
				main.print_message("You coward! You ran away from the " + g.monster[mon_index][0] + ".")
				global did_run
				did_run = 1
			else:
				main.print_message("You fail to run away.")
				attack_player()
	except TclError:
		pass

#Use item button was pressed
def useitem():
	#don't do anything if anyone is dead.
	if g.cur_mon_hp < 1 or g.hp < 1:
		return 0

	#put the name of the item into item_name
	if (len(listbox_item.curselection()) == 0): return 0

	try: item_num = map(int, listbox_item.curselection())
	except ValueError: pass


	item_name = listbox_item.get(item_num[0])


	#find the item[] index and item type
	item_value = g.finditem(item_name)
	item_type = g.item[item_value][1]

	#if item is healing
	if item_type == 11:
		#heal the player, delete the item
		g.hp=g.hp + g.item[item_value][2]
		main.print_message("You are healed for " +
					str(g.item[item_value][2]) + " health.")
		g.drop_inv_item(g.find_inv_item(item_value))
		if g.hp >= g.maxhp: g.hp = g.maxhp
		attack_player()

	#if item is explosive
	if item_type == 12:
		#if monster is still alive
		if g.cur_mon_hp > 0:
			damage = int(g.item[item_value][2])
			g.drop_inv_item(g.find_inv_item(item_value))
			if damage > 0:
				main.print_message("The " + g.monster[mon_index][0] +
					" is hit for " + str(damage) + " damage.")
			g.cur_mon_hp = g.cur_mon_hp - damage
			#you kill it?
			if g.cur_mon_hp <= 0:
				monster_dead()
			else:
				attack_player()
	refresh()

	#replace the cursor
	if (listbox_item.size() == 0): return 0

	listbox_item.selection_set(item_num[0])
	if (len(listbox_item.curselection()) == 0): #last item
		listbox_item.selection_set(item_num[0] - 1)



def useskill():
	#don't do anything if monster is dead.
	if g.cur_mon_hp < 1 or g.hp < 1:
		return 0

	#get the skill name.
	if (len(listbox_skill.curselection()) == 0): return 0

	try: skill_num = map(int, listbox_skill.curselection())
	except ValueError: pass

	skill_raw_name = listbox_skill.get(skill_num[0])
	skill_array_name = skill_raw_name.split(":", 1)

	#get the skill[] index
	skill_index = g.findskill(skill_array_name[0])

	#make sure we can use that skill, just in case. . .
	if g.skill[skill_index][5] == 0 or g.skill[skill_index][2] > g.ep:
		return 0

	#pay for the skill
	g.ep = int(g.ep) - g.skill[skill_index][2]


	#actually use the skill.
	if g.skill[skill_index][1] == 0: #rage
		main.print_message("You fly into a rage.")
		#increase attack ability
		g.adj_attack += (1 + int(g.level)/2)
		attack_player()

	elif g.skill[skill_index][1] == 1: #Sneak away
		if g.die_roll(1, 10 + int(g.level)) > 5:
			main.print_message("You coward! You ran away from the " + g.monster[mon_index][0] + ".")
			window_battle.destroy()
			global did_run
			did_run = 1
			return 0
		else:
			main.print_message("You fail to sneak away.")
			attack_player()
	elif g.skill[skill_index][1] == 2: #Doublehit
		for i in range(2 + int(g.level)/3):
			attack_monster()
			if g.cur_mon_hp <= 0:
				break
		if g.cur_mon_hp > 0:
			attack_player()
	elif g.skill[skill_index][1] == 3: #Dismember
		damage = g.adj_attack + 2
		main.print_message("You hit the " + g.monster[mon_index][0] +
			" for " + str(damage) + " damage.")
		g.cur_mon_hp = g.cur_mon_hp - damage
		#you kill it?
		if g.cur_mon_hp <= 0:
			monster_dead()
		else:
			attack_player()

	refresh()
	refresh_buttons()

	#replace the cursor
	if (listbox_skill.size() == 0): return 0

	listbox_skill.selection_set(skill_num[0])
	if (len(listbox_skill.curselection()) == 0): #last skill
		listbox_skill.selection_set(END)



def refresh_buttons():
	canvas_buttons.delete(ALL)

	if (cur_button == 0):
		canvas_buttons.create_image(attack_button_loc, 0, anchor=NW,
					image=attack_button_sel)
		help_text.set("Attack monster")
	else: canvas_buttons.create_image(attack_button_loc, 0, anchor=NW,
					image=attack_button)
	if (cur_button == 1):
		if g.hp <= 0:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=quit_button_sel)
			help_text.set("Quit")
		elif g.cur_mon_hp > 0:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=run_button_sel)
			help_text.set("Run away")
		else:
			canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
				image=leave_button_sel)
			help_text.set("Leave")
        elif g.hp <= 0:
	        canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
			image=quit_button)
	elif g.cur_mon_hp > 0:
	        canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
			image=run_button)
        else: canvas_buttons.create_image(run_button_loc, 0, anchor=NW,
			image=leave_button)

	if (cur_button == 2):
		listbox_skill.select_clear(0, END)
	        canvas_buttons.create_image(item_button_loc, 0,
			anchor=NW, image=item_button_sel)
		if (len(listbox_item.curselection()) == 0):
			help_text.set("No items")
		else:
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			item_name = listbox_item.get(item_num[0])
			help_text.set("Use your " + item_name)
        else: canvas_buttons.create_image(item_button_loc, 0,
			anchor=NW, image=item_button)
	if (cur_button == 3):
		listbox_item.select_clear(0, END)
	        canvas_buttons.create_image(skill_button_loc, 0,
			anchor=NW, image=skill_button_sel)
		if (len(listbox_skill.curselection()) == 0):
			help_text.set("No useable skills")
		else:
			try: skill_num = map(int, listbox_skill.curselection())
			except ValueError: pass
			skill_name = listbox_skill.get(skill_num[0])
			help_text.set("Use " + skill_name)
        else: canvas_buttons.create_image(skill_button_loc, 0,
			anchor=NW, image=skill_button)


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	if (key_name == "esc"):
		runaway()
		return 0
	elif  (key_name == "right"):
		cur_button += 1
		if (cur_button == 1): cur_button = 2 #run is now at end
		elif (cur_button == 2): cur_button = 0 #run is now at end
		if (cur_button == 2): #switch to items
			if (len(listbox_item.curselection()) == 0):
				listbox_item.selection_set(0)
		if (cur_button == 3): #switch to skills
			listbox_item.select_clear(0, END)
			if (len(listbox_skill.curselection()) == 0):
				listbox_skill.selection_set(0)
		if (cur_button == 4): #switch to run
			cur_button = 1
			listbox_skill.select_clear(0, END)
	elif  (key_name == "left"):
		cur_button -= 1
		if (cur_button == -1): cur_button = 1 #loop around
		elif (cur_button == 1): cur_button = 0
		elif (cur_button == 0): cur_button = 3
		#if (cur_button == 0): cur_button = 3
		if (cur_button == 0): #switch to attack
		#	cur_button = 0
			listbox_item.select_clear(0, END)
		if (cur_button == 2): #switch to items
			listbox_skill.select_clear(0, END)
			if (len(listbox_item.curselection()) == 0):
				listbox_item.selection_set(0)
		if (cur_button == 3): #switch to skills
			if (len(listbox_skill.curselection()) == 0):
				listbox_skill.selection_set(0)
	elif (key_name == "up"):
		#if (cur_button == 0): cur_button = 1
		#elif (cur_button == 1): cur_button = 0
		if (cur_button == 2):
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != 0):
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(item_num[0] - 1)
					listbox_item.see(item_num[0] - 1)
				else:
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(END)
					listbox_item.see(END)
			except IndexError: pass
		if (cur_button == 3):
			try:
				try: skill_num = map(int, listbox_skill.curselection())
				except ValueError: pass
				if (skill_num[0] != 0):
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(skill_num[0] - 1)
					listbox_skill.see(skill_num[0] - 1)
				else:
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(END)
					listbox_skill.see(END)
			except IndexError: pass

	elif (key_name == "down"):
		#if (cur_button == 0): cur_button = 1
		#elif (cur_button == 1): cur_button = 0
		if (cur_button == 2):
			try: item_num = map(int, listbox_item.curselection())
			except ValueError: pass
			try:
				if (item_num[0] != listbox_item.size() - 1):
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(item_num[0] + 1)
					listbox_item.see(item_num[0] + 1)
				else:
					listbox_item.select_clear(0, END)
					listbox_item.selection_set(0)
					listbox_item.see(0)
			except IndexError: pass
		elif (cur_button == 3):
			try: skill_num = map(int, listbox_skill.curselection())
			except ValueError: pass
			try:
				if (skill_num[0] != listbox_skill.size() - 1):
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(skill_num[0] + 1)
					listbox_skill.see(skill_num[0] + 1)
				else:
					listbox_skill.select_clear(0, END)
					listbox_skill.selection_set(0)
					listbox_skill.see(0)
			except IndexError: pass

	elif (key_name == "return"):
		if (cur_button == 0):
			attack()
			return 0
		elif (cur_button == 1):
			runaway()
			return 0
		elif (cur_button == 2): useitem()
		elif (cur_button == 3):
			useskill()
			return

	refresh_buttons()



def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")

def mouse_handler_click(event=0):
	mouse_handler_move(event)
	key_handler("return")

def mouse_handler_item(event=0):
	global cur_button; cur_button = 2
	refresh_buttons()

def mouse_handler_skill(event=0):
	global cur_button; cur_button = 3
	refresh_buttons()

def mouse_handler_move(event=0):
	global cur_button
	if (event.x < item_button_loc):
		cur_button = 0
		listbox_item.select_clear(0, END)
		listbox_skill.select_clear(0, END)
	elif (event.x < skill_button_loc):
		cur_button = 2
		listbox_skill.select_clear(0, END)
		if (len(listbox_item.curselection()) == 0):
			listbox_item.selection_set(0)
	elif (event.x < run_button_loc):
		cur_button = 3
		listbox_item.select_clear(0, END)
		if (len(listbox_skill.curselection()) == 0):
			listbox_skill.selection_set(0)
	else:
		cur_button = 1
		listbox_item.select_clear(0, END)
		listbox_skill.select_clear(0, END)
	refresh_buttons()

#start a battle.
def begin(mon_index_input):

	global window_battle
	global bgcolour
	bgcolour = "lightgrey"
	window_battle = Frame(main.top, bd=2, relief=SUNKEN, bg=bgcolour)
	window_battle.grid(row=1, column=5, columnspan=13, rowspan=13, sticky=E)
	global mon_index
	mon_index = mon_index_input
	global cur_mon_hp
	g.cur_mon_hp = g.monster[mon_index][1]
	global did_run
	did_run = 0
	global cur_button
	cur_button = 0

	global canvas_desc
	canvas_desc = Canvas(window_battle, width=200, height=190,
		highlightthickness=0, bg=bgcolour)
	canvas_desc.grid(row=2, column=1, sticky=NSEW)
	canvas_desc.create_text(1, 5, anchor=NW,
			text=g.monster[mon_index][6], width=195)

	pic_frame = Frame(window_battle, bd=2, relief=SUNKEN, bg="#327a22")
	pic_frame.grid(row=1, column=2, columnspan=3, rowspan=6, sticky=E)

	global canvas_mon_pic
	if os.path.isfile(g.mod_directory +
			"/images/monsters/" + g.monster[mon_index][0] + ".png"):
		monster_pic = ImageTk.PhotoImage(file=g.mod_directory +
			"/images/monsters/" + g.monster[mon_index][0] + ".png")
	else:
		monster_pic = ImageTk.PhotoImage(file=g.mod_directory +
			"/images/monsters/generic.png")
	canvas_mon_pic = Canvas(pic_frame,
		height=monster_pic.height(),
		width=monster_pic.width())
	canvas_mon_pic.grid(column=2, row=1, rowspan=5, sticky=NW)
	canvas_mon_pic.create_image(0, 0, anchor=NW, image=monster_pic)


	global canvas_mon_hp
	canvas_mon_hp = Canvas(pic_frame, width=g.hpbar_width,
		height=g.hpbar_width/6, highlightthickness=0)
	canvas_mon_hp.grid(column=2, row=5)
	canvas_mon_hp.create_rectangle(0, 0, g.hpbar_width,
		g.hpbar_width/6, fill="#EE0505")


	#formatting for the labels.
	label_formatting = Label(window_battle, text=g.monster[mon_index][0],
		bg=bgcolour).grid(row=1, column=1, columnspan=2)
	label_formatting = Label(pic_frame,
		text="HP:", bg="#327a22").grid(row=5, column=2, sticky=W, padx=2)


	#stat display
	label_mon_hp = Label(pic_frame, textvariable=mon_hp,
		bg="#327a22").grid(row=5, column=2, sticky=E, padx=2)

	label_attack = Label(window_battle, text="Attack: " +
	str(g.monster[mon_index][2]), bg=bgcolour).grid(row=4, column=1, sticky=W)
	label_defend = Label(window_battle, text="Defense: " +
	str(g.monster[mon_index][3]), bg=bgcolour).grid(row=4, column=1, sticky=E)

	#help text
	label_text = Label(window_battle,
		textvariable=help_text, bg=bgcolour)
	label_text.grid(column=1, row=5, columnspan=2)
	window_battle.update_idletasks()
	window_battle.columnconfigure(1, minsize=canvas_mon_pic.winfo_width())


	button_frame = Frame(window_battle, bg=bgcolour)
	button_frame.grid(row=14, column=1, columnspan=2, sticky="NSEW")

	#Attack and run buttons.
	global attack_button; global attack_button_sel
	global run_button; global run_button_sel
	global quit_button; global quit_button_sel
	global leave_button; global leave_button_sel
	global item_button; global item_button_sel
	global skill_button; global skill_button_sel

	attack_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/attack.png")
	run_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/run.png")
	attack_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/attack_sel.png")
	run_button_sel = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/run_sel.png")
	quit_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/quit_battle.png")
	leave_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave.png")
	item_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use.png")
	skill_button = ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/skill.png")
	quit_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/quit_battle_sel.png")
	leave_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/leave_sel.png")
	item_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/use_sel.png")
	skill_button_sel = \
		ImageTk.PhotoImage(file=g.mod_directory + \
		"/images/buttons/skill_sel.png")

	global item_button_loc
	global skill_button_loc
	global run_button_loc
	item_button_loc = attack_button.width()
	skill_button_loc = item_button_loc + item_button.width()
	run_button_loc = skill_button_loc + skill_button.width()

	global canvas_buttons
	canvas_buttons = Canvas(button_frame,
		height=attack_button.height(),
		width=attack_button.width() + run_button.width() +
		item_button.width() + skill_button.width())
	canvas_buttons.grid(column=1, row=1, sticky="NSEW")

	#use item listbox
	item_label = Label(window_battle, text='Items', bg=bgcolour)
	item_label.grid(row=9, column=1, sticky=N)

	global listbox_item
	listbox_item = Listbox(window_battle, height=5, bg=bgcolour)
	listbox_item.grid(row=9, column=1, rowspan=5, sticky=N+S+E+W)
	global item_scroll
	item_scroll = Scrollbar(window_battle, command=listbox_item.yview,
		bg=bgcolour)
	item_scroll.grid(row=9, column=1, rowspan=5, sticky=N+S+E)
	listbox_item.config(yscrollcommand=item_scroll.set)

	#use skill listbox
#	skill_frame = Frame(window_battle, background="#003300")
#	skill_frame.grid(row=9, column=3, sticky=N+S+E+W)

	skill_label = Label(window_battle, text='Skills', bg=bgcolour)
	skill_label.grid(row=9, column=2, sticky=N)

	global listbox_skill
	listbox_skill = Listbox(window_battle, height=5, bg=bgcolour)
	listbox_skill.grid(row=9, column=2, rowspan=5, sticky="NSEW")
	global skill_scroll
	skill_scroll = Scrollbar(window_battle, command=listbox_skill.yview,
		bg=bgcolour)
	skill_scroll.grid(row=9, column=2, rowspan=5, sticky=N+S+E)
	listbox_skill.config(yscrollcommand=skill_scroll.set)
	window_battle.update_idletasks()
	window_battle.columnconfigure(2, minsize=pic_frame.winfo_width())



	#bindings
	main.window_main.bind("a", attack)
	main.window_main.bind("<Escape>", key_handler_esc)
	main.window_main.bind("<Return>", key_handler_return)
	main.window_main.bind("<Up>", key_handler_up)
	main.window_main.bind("<Down>", key_handler_down)
	main.window_main.bind("<Left>", key_handler_left)
	main.window_main.bind("<Right>", key_handler_right)
	main.window_main.bind("i", key_handler)
	main.window_main.bind("s", key_handler)
	main.window_main.bind("q", key_handler)


	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)
	listbox_item.bind("<ButtonRelease-1>", mouse_handler_item)
	listbox_skill.bind("<ButtonRelease-1>", mouse_handler_skill)

	main.print_message("The " + g.monster[mon_index][0] + " attacks you.")

	refresh()
	refresh_buttons()

	#keep the window_main window asleep until this one is closed.
	window_battle.master.wait_window(window_battle)
	return did_run


