#file: new_game.py
#Copyright (C) 2004 Free Software Foundation
#see GPL.txt for license.

#This file creates a new character.
#Either call directly (which will use the first module seen), or
#call from rpg.py after setting g.mod_directory.

from Tkinter import *
#needed for the buttons.
import ImageTk
import Image

import g

#if called directly, pick a module.
if __name__ == "__main__":
	from os import listdir
	array_mods = listdir("../modules/")
	i = 0
        while i < len(array_mods):
                if array_mods[i] == "CVS":
                        array_mods.pop(i)
                else:
                        i += 1
	g.mod_directory = "../modules/" + array_mods[0]
	window_new_game = Tk()
	g.init_data()

import main
import loadgame

#main stats for character. Taken from g.hp etc.
name = StringVar()
hp = StringVar()
ep = StringVar()
attack = StringVar()
defense = StringVar()
gold = StringVar()

help_text = StringVar()

#distance from the top of the button canvas each button should be placed.
#Values are added in init_window. begin is not needed; always zero.
reroll_height = 0
load_height = 0
quit_height = 0

#currently selected button. 0=Begin, 1=Reroll, 2=Load, 3=Quit
cur_button = 0

#give new stats for the character. Called when pressing the
#"Reroll stats" button. This is longer than expected, as the
#"Begin game" button must also work when loading a game, so all
#game-start stuff has been placed in here.
#It seems to run fast enough, though.
def reroll_stats():
	g.name = name.get()

	#actual re-rolling
	hp.set(g.die_roll(g.new_game_dice[0][0], g.new_game_dice[0][1]) +
		g.new_game_dice[0][2])
	ep.set(g.die_roll(g.new_game_dice[1][0], g.new_game_dice[1][1]) +
		g.new_game_dice[1][2])
	attack.set(g.die_roll(g.new_game_dice[2][0], g.new_game_dice[2][1]) +
		g.new_game_dice[2][2])
	defense.set(g.die_roll(g.new_game_dice[3][0], g.new_game_dice[3][1]) +
		g.new_game_dice[3][2])
	gold.set(g.die_roll(g.new_game_dice[4][0], g.new_game_dice[4][1]) +
		g.new_game_dice[4][2])

	reset_vars()


#call to reset the game
def reset_vars():
	#move variables to g.*
	g.maxhp = int(hp.get())
	g.maxep = int(ep.get())
	g.attack = int(attack.get())
	g.defense = int(defense.get())
	g.gold = int(gold.get())

	g.exp = 0
	g.level = 0
	g.skillpoints = 0
	g.hp = g.maxhp
	g.ep = g.maxep

	#place the player
	g.xgrid = 0
	g.ygrid= 0
	g.zgrid = 0

	timestep = 0
	cur_mon_hp = 0
	g.var_list = {}

	#clear the inventory
	for i in range(len(g.inv)):
		g.inv[i]= -1
	for i in range(len(g.equip)):
		g.equip[i]= -1
	#clear skills
	for i in range(len(g.skill)):
		g.skill[i][5] = 0
	global new_game
	new_game = 1


#get stats from g.*
def get_stats():
	name.set(g.name)
	hp.set(g.hp)
	ep.set(g.ep)
	attack.set(g.attack)
	defense.set(g.defense)
	gold.set(g.gold)


#Use the stats given to create a new character.
def begin_game():
	#just in case someone changed the name
	#after rerolling or loading
	g.name = name.get()

	#start the game with 100000 gold if player is named "testing123".
	if g.name == "testing123":
		g.gold = 100000
	if g.name == "":
		g.name = "Nameless"
	#bring the main window up.
	window_new_game.withdraw()
	main.init_window_main(new_game)
	try:
		if window_new_game.winfo_exists():
			window_new_game.deiconify()
	except TclError:
		pass

	#after returning to this screen, reset everything.
	reroll_stats()

def load_game():
	#bring the loadgame window up.
	window_new_game.withdraw()
	global new_game
	load_game = 0
	load_game = loadgame.init_window_loadgame()
	if load_game == 1: new_game = 0
	try:
		if window_new_game.winfo_exists():
			window_new_game.deiconify()
	except TclError:
		pass
	get_stats()

def quit_game():
	window_new_game.destroy()

#refresh the buttons.
def refresh_buttons():
	canvas_buttons.delete(ALL)
	if (cur_button == 0):
		canvas_buttons.create_image(0, 0, anchor=NW,
							image=begin_button_sel, tags="begin")
		help_text.set("Begin a new game")
	else: canvas_buttons.create_image(0, 0, anchor=NW,
							image=begin_button, tags="begin")
	if (cur_button == 1):
		canvas_buttons.create_image(0, reroll_height, anchor=NW,
							image=reroll_button_sel, tags="reroll")
		help_text.set("Reroll your statistics")
	else: canvas_buttons.create_image(0, reroll_height, anchor=NW,
							image=reroll_button, tags="reroll")
	if (cur_button == 2):
		canvas_buttons.create_image(0, load_height, anchor=NW,
							image=load_button_sel, tags="load")
		help_text.set("Load an old game")
	else: canvas_buttons.create_image(0, load_height, anchor=NW,
							image=load_button, tags="load")
	if (cur_button == 3):
		canvas_buttons.create_image(0, quit_height, anchor=NW,
							image=quit_button_sel, tags="quit")
		help_text.set("Quit this game")
	else: canvas_buttons.create_image(0, quit_height, anchor=NW,
							image=quit_button, tags="quit")


#All keypresses in window_shop pass through here. Based on the key name,
#give the right action. ("etc", "left", "right", "up", "down", "return")
def key_handler(key_name):
	global cur_button
	entry_name.focus_set()
	if (key_name == "esc"):
		quit_game()
		return 0
	elif (key_name == "up"):
		cur_button -= 1
		if (cur_button == -1): cur_button = 3
	elif (key_name == "down"):
		cur_button += 1
		if (cur_button == 4): cur_button = 0
	elif (key_name == "left"):
		pass
	elif (key_name == "right"):
		pass
	elif (key_name == "return"):
		if   (cur_button == 0):
			begin_game()
		elif (cur_button == 1):
			reroll_stats()
		elif (cur_button == 2):
			load_game()
		elif (cur_button == 3):
			quit_game()
			return 0

	refresh_buttons()


def key_handler_esc(event=0): key_handler("esc")
def key_handler_left(event=0): key_handler("left")
def key_handler_right(event=0): key_handler("right")
def key_handler_down(event=0): key_handler("down")
def key_handler_up(event=0): key_handler("up")
def key_handler_return(event=0): key_handler("return")


def mouse_handler_click(event=0):
	key_handler("return")

def mouse_handler_move(event=0):
	global cur_button
	if (event.y < reroll_height): cur_button = 0
	elif (event.y < load_height): cur_button = 1
	elif (event.y < quit_height): cur_button = 2
	else: cur_button = 3
	refresh_buttons()

#called upon game start
def init_window():
	if __name__ != "__main__":
		global window_new_game
		window_new_game = Toplevel()
	window_new_game.title(g.game_name)
	window_new_game.resizable(0, 0)
	window_new_game.maxsize(1000, 1000)
	window_new_game.wm_geometry("+%d+%d" % (20, 20))

	global bgcolour
	bgcolour="lightgrey"

	new_game = Frame(window_new_game, bg=bgcolour)
        new_game.grid(row=0, column=0);

	global label_help
	label_help = Label(new_game, textvariable=help_text, bg=bgcolour)
	label_help.grid(row=1, column=3, sticky=W) #, columnspan=3)

	#formatting for the labels.
	label_formatting = Label(new_game,
		text="Name:", bg=bgcolour).grid(row=2, column=2, sticky=E+S)
	label_formatting = Label(new_game,
		text="Hit points:", bg=bgcolour).grid(row=3, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Energy points:", bg=bgcolour).grid(row=4, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Attack:", bg=bgcolour).grid(row=5, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Defense:", bg=bgcolour).grid(row=6, column=2, sticky=E)
	label_formatting = Label(new_game,
		text="Gold:", bg=bgcolour).grid(row=7, column=2, sticky=E+N)

	#display of stats
	name.set("Alfred")
	global entry_name
	entry_name = Entry(new_game, bg= 'white',
		textvariable=name)
	entry_name.grid(row=2, column=3, sticky=W+S)
	label_hp = Label(new_game,
		textvariable=hp, bg=bgcolour).grid(row=3, column=3, sticky=W)
	label_ep = Label(new_game,
		textvariable=ep, bg=bgcolour).grid(row=4, column=3, sticky=W)
	label_attack = Label(new_game,
		textvariable=attack, bg=bgcolour).grid(row=5, column=3, sticky=W)
	label_defense = Label(new_game,
		textvariable=defense, bg=bgcolour).grid(row=6, column=3, sticky=W)
	label_gold = Label(new_game,
		textvariable=gold, bg=bgcolour).grid(row=7, column=3, sticky=W+N)


	#Actual buttons, both selected and normal.
	global begin_button; global begin_button_sel
	global reroll_button; global reroll_button_sel
	global load_button; global load_button_sel
	global quit_button; global quit_button_sel


	begin_button = \
		ImageTk.PhotoImage(file=g.mod_directory + "/images/buttons/begin.png")
	reroll_button = \
		ImageTk.PhotoImage(file=g.mod_directory + "/images/buttons/reroll.png")
	load_button = \
		ImageTk.PhotoImage(file=g.mod_directory + "/images/buttons/load.png")
	quit_button = \
		ImageTk.PhotoImage(file=g.mod_directory + "/images/buttons/quit.png")

	begin_button_sel = ImageTk.PhotoImage(
		file=g.mod_directory + "/images/buttons/begin_sel.png")
	reroll_button_sel = ImageTk.PhotoImage(
		file=g.mod_directory + "/images/buttons/reroll_sel.png")
	load_button_sel = ImageTk.PhotoImage(
		file=g.mod_directory + "/images/buttons/load_sel.png")
	quit_button_sel = ImageTk.PhotoImage(
		file=g.mod_directory + "/images/buttons/quit_sel.png")

	#Canvas for buttons
	global canvas_buttons
	canvas_buttons = Canvas(new_game, width=begin_button.width(),
		height=begin_button.height() + reroll_button.height() +
		load_button.height() + quit_button.height(), highlightthickness=0)
	canvas_buttons.grid(column=1, row=1, rowspan=20, sticky=N+W+E)

	#add height values
	global reroll_height
	global load_height
	global quit_height
	reroll_height = begin_button.height()
	load_height = reroll_height + reroll_button.height()
	quit_height = load_height + load_button.height()

	entry_name.focus_set()
	refresh_buttons()

	#give basic values.
	reroll_stats()

	#bindings
	window_new_game.bind("<Escape>", key_handler_esc)
	window_new_game.bind("<Return>", key_handler_return)
	window_new_game.bind("<Up>", key_handler_up)
	window_new_game.bind("<Down>", key_handler_down)
	window_new_game.bind("<Left>", key_handler_left)
	window_new_game.bind("<Right>", key_handler_right)
	canvas_buttons.bind("<ButtonRelease-1>", mouse_handler_click)
	canvas_buttons.bind("<Motion>", mouse_handler_move)

	if __name__ != "__main__":
		window_new_game.master.wait_window(window_new_game)

if __name__ == "__main__":
	init_window()

	window_new_game.mainloop()
